/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.socket.http.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.phosphoresce.commons.util.StreamUtil;
import org.phosphoresce.socket.http.container.HttpSocketRequest;
import org.phosphoresce.socket.http.container.HttpSocketResponse;
import org.phosphoresce.socket.http.io.HttpSocketContentInputStream;
import org.phosphoresce.socket.http.io.HttpSocketContentOutputStream;

public final class HttpSocketClientUtil {
    private HttpSocketClientUtil() {
    }

    public static HttpSocketRequest readRequest(InputStream stream, int bufferSize) throws IOException {
        String header;
        HttpSocketRequest request = new HttpSocketRequest();
        request.setIdentifier(StreamUtil.readLine((InputStream)stream));
        while ((header = StreamUtil.readLine((InputStream)stream)).length() != 0) {
            request.addHeader(header);
        }
        request.setContentStream(new HttpSocketContentInputStream(stream, request.isChunkedContent(), request.getContentLength(), bufferSize));
        return request;
    }

    public static HttpSocketResponse readResponse(InputStream stream, int bufferSize) throws IOException {
        String header;
        HttpSocketResponse response = new HttpSocketResponse();
        response.setIdentifier(StreamUtil.readLine((InputStream)stream));
        while ((header = StreamUtil.readLine((InputStream)stream)).length() != 0) {
            response.addHeader(header);
        }
        response.setContentStream(new HttpSocketContentInputStream(stream, response.isChunkedContent(), response.getContentLength(), bufferSize));
        return response;
    }

    public static void writeRequest(OutputStream stream, HttpSocketRequest request, int bufferSize) throws IOException {
        int i;
        StreamUtil.writeLine((OutputStream)stream, (String)request.getIdentifier());
        String[] headerStrings = request.getHeaderStrings();
        String[] cookieStrings = request.getCookieStrings();
        for (i = 0; i <= headerStrings.length - 1; ++i) {
            StreamUtil.writeLine((OutputStream)stream, (String)headerStrings[i]);
        }
        for (i = 0; i <= cookieStrings.length - 1; ++i) {
            StreamUtil.writeLine((OutputStream)stream, (String)cookieStrings[i]);
        }
        StreamUtil.writeLine((OutputStream)stream);
        if (request.getContentStream() != null) {
            HttpSocketContentOutputStream contentOutputStream = new HttpSocketContentOutputStream(stream, request.isChunkedContent(), bufferSize);
            InputStream contentInputStream = request.getContentStream();
            while (contentInputStream.available() > 0) {
                byte[] bytes = new byte[contentInputStream.available()];
                contentInputStream.read(bytes);
                contentOutputStream.write(bytes);
            }
            if (request.isChunkedContent()) {
                contentOutputStream.writeEOC();
            }
            contentOutputStream.flush();
        }
    }

    public static void writeResponse(OutputStream stream, HttpSocketResponse response, int bufferSize) throws IOException {
        int i;
        StreamUtil.writeLine((OutputStream)stream, (String)response.getIdentifier());
        String[] headerStrings = response.getHeaderStrings();
        String[] cookieStrings = response.getCookieStrings();
        for (i = 0; i <= headerStrings.length - 1; ++i) {
            StreamUtil.writeLine((OutputStream)stream, (String)headerStrings[i]);
        }
        for (i = 0; i <= cookieStrings.length - 1; ++i) {
            StreamUtil.writeLine((OutputStream)stream, (String)cookieStrings[i]);
        }
        StreamUtil.writeLine((OutputStream)stream);
        if (response.getContentStream() != null) {
            HttpSocketContentOutputStream contentOutputStream = new HttpSocketContentOutputStream(stream, response.isChunkedContent(), bufferSize);
            InputStream contentInputStream = response.getContentStream();
            while (contentInputStream.available() > 0) {
                int readSize = contentInputStream.available() > bufferSize ? bufferSize : contentInputStream.available();
                byte[] bytes = new byte[readSize];
                contentInputStream.read(bytes);
                contentOutputStream.write(bytes);
            }
            if (response.isChunkedContent()) {
                contentOutputStream.writeEOC();
            }
            contentOutputStream.flush();
        }
    }
}

