/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.socket.http.io;

import java.io.IOException;
import java.net.Socket;
import org.phosphoresce.socket.core.io.SocketRelayStream;
import org.phosphoresce.socket.core.io.SocketStream;
import org.phosphoresce.socket.http.container.HttpSocketRequest;
import org.phosphoresce.socket.http.container.HttpSocketResponse;

public final class HttpSocketRelayStream
extends SocketRelayStream {
    public HttpSocketRelayStream() {
    }

    public HttpSocketRelayStream(Socket source, Socket destination) throws IOException {
        super(source, destination);
    }

    public HttpSocketRelayStream(SocketStream source, SocketStream destination) {
        super(source, destination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int forwardChunk(int bufferSize) throws IOException {
        this.streaming = true;
        try {
            String footer;
            int forwardedSize = 0;
            while (true) {
                String chunkIdentifier;
                String chunkSizeBlock = (chunkIdentifier = this.forwardLine()).indexOf(";") >= 0 ? chunkIdentifier.substring(0, chunkIdentifier.indexOf(";")) : chunkIdentifier;
                int chunkSize = Integer.parseInt(chunkSizeBlock.trim(), 16);
                forwardedSize += chunkSize;
                if (chunkSize == 0) break;
                this.forward(chunkSize, bufferSize);
                this.forwardLine();
            }
            while ((footer = this.forwardLine()).length() != 0) {
            }
            int n = forwardedSize;
            return n;
        }
        finally {
            this.streaming = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readRequest(HttpSocketRequest request) throws IOException {
        this.streaming = true;
        try {
            String header;
            request.setIdentifier(this.source.readLine());
            while ((header = this.source.readLine()).length() != 0) {
                request.addHeader(header);
            }
        }
        finally {
            this.streaming = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeRequest(HttpSocketRequest request) throws IOException {
        this.streaming = true;
        try {
            this.destination.writeLine(request.getIdentifier());
            String[] headerStrings = request.getHeaderStrings();
            for (int i = 0; i <= headerStrings.length - 1; ++i) {
                this.destination.writeLine(headerStrings[i]);
            }
            this.destination.writeSeparate();
        }
        finally {
            this.streaming = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forwardRequest() throws IOException {
        this.streaming = true;
        try {
            HttpSocketRequest request = new HttpSocketRequest();
            this.readRequest(request);
            this.writeRequest(request);
        }
        finally {
            this.streaming = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readResponse(HttpSocketResponse response) throws IOException {
        this.streaming = true;
        try {
            String header;
            response.setIdentifier(this.source.readLine());
            while ((header = this.source.readLine()).length() != 0) {
                response.addHeader(header);
            }
        }
        finally {
            this.streaming = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeResponse(HttpSocketResponse response) throws IOException {
        this.streaming = true;
        try {
            this.destination.writeLine(response.getIdentifier());
            String[] headerStrings = response.getHeaderStrings();
            for (int i = 0; i <= headerStrings.length - 1; ++i) {
                this.destination.writeLine(headerStrings[i]);
            }
            this.destination.writeSeparate();
        }
        finally {
            this.streaming = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forwardResponse() throws IOException {
        this.streaming = true;
        try {
            HttpSocketResponse response = new HttpSocketResponse();
            this.readResponse(response);
            this.writeResponse(response);
        }
        finally {
            this.streaming = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int forwardRequsetContent(HttpSocketRequest request, int bufferSize) throws IOException {
        this.streaming = true;
        try {
            int contentLength = request.getHeader("Content-Length").getValueOfInteger();
            int forwardedSize = 0;
            if ("chunked".equalsIgnoreCase(request.getHeader("Transfer-Encoding").getHeaderString())) {
                forwardedSize = this.forwardChunk(bufferSize);
            } else if (contentLength == -1) {
                forwardedSize = this.forwardEOS(bufferSize);
            } else if (contentLength > 0) {
                forwardedSize = this.forward(contentLength, bufferSize);
            }
            int n = forwardedSize;
            return n;
        }
        finally {
            this.streaming = false;
        }
    }
}

