/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.socket.http.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.phosphoresce.commons.util.StreamUtil;
import org.phosphoresce.socket.core.SocketGlobal;

public class HttpSocketContentInputStream
extends InputStream {
    private InputStream stream = null;
    private boolean chunked = false;
    private long contentLength = -1L;
    private ByteArrayInputStream buffer = new ByteArrayInputStream(new byte[0]);
    private int bufferSize = SocketGlobal.DEFAULT_STREAM_BUFFER_SIZE;
    private boolean eos = false;
    private long totalSize = 0L;

    private HttpSocketContentInputStream() {
    }

    public HttpSocketContentInputStream(InputStream stream, boolean chunked, long contentLength, int bufferSize) throws IOException {
        this.stream = stream;
        this.chunked = chunked;
        this.contentLength = contentLength;
        this.bufferSize = bufferSize < 0 ? 1 : bufferSize;
        this.eos = false;
        this.totalSize = 0L;
    }

    public HttpSocketContentInputStream(InputStream stream, boolean chunked, long contentLength) throws IOException {
        this.stream = stream;
        this.chunked = chunked;
        this.contentLength = contentLength;
        this.bufferSize = SocketGlobal.DEFAULT_STREAM_BUFFER_SIZE;
        this.eos = false;
        this.totalSize = 0L;
    }

    public boolean isChunked() {
        return this.chunked;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    private void readBuffer() throws IOException {
        if (this.eos || this.buffer.available() > 0) {
            return;
        }
        if (this.chunked) {
            int readSize = this.readChunkedNextSize();
            this.buffer = new ByteArrayInputStream(StreamUtil.reads((InputStream)this.stream, (int)readSize));
            this.totalSize += (long)this.buffer.available();
            if (this.buffer.available() == 0) {
                this.eos = true;
            }
            StreamUtil.readLine((InputStream)this.stream);
        } else {
            if (this.contentLength == 0L) {
                this.eos = true;
                return;
            }
            if (this.contentLength > 0L) {
                int readSize = (int)(this.totalSize + (long)this.bufferSize > this.contentLength ? this.contentLength - this.totalSize : (long)this.bufferSize);
                this.buffer = new ByteArrayInputStream(StreamUtil.reads((InputStream)this.stream, (int)readSize));
                this.totalSize += (long)this.buffer.available();
                if (this.contentLength <= this.totalSize) {
                    this.eos = true;
                }
            } else {
                if (this.stream.available() <= 0) {
                    this.eos = true;
                    return;
                }
                this.buffer = new ByteArrayInputStream(new byte[]{(byte)this.stream.read()});
                ++this.totalSize;
            }
        }
    }

    private int readChunkedNextSize() throws IOException {
        String chunkIdentifier = StreamUtil.readLine((InputStream)this.stream);
        String chunkSizeBlock = chunkIdentifier.indexOf(";") >= 0 ? chunkIdentifier.substring(0, chunkIdentifier.indexOf(";")).trim() : chunkIdentifier.trim();
        return Integer.parseInt(chunkSizeBlock.trim(), 16);
    }

    public int read() throws IOException {
        this.readBuffer();
        return this.buffer.available() > 0 ? this.buffer.read() : -1;
    }

    public int available() throws IOException {
        this.readBuffer();
        return this.buffer.available();
    }

    public void close() throws IOException {
        this.stream.close();
    }
}

