/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.socket.http.container;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import org.phosphoresce.commons.util.StringUtil;
import org.phosphoresce.socket.core.SocketGlobal;
import org.phosphoresce.socket.http.HttpResponseStatus;
import org.phosphoresce.socket.http.container.HttpSocketHeaderContainer;

public class HttpSocketResponse
extends HttpSocketHeaderContainer {
    private String protocol;
    private String version;
    private HttpResponseStatus status;
    private String message;
    private List headers;
    private List cookies;
    private InputStream contentStream;

    public HttpSocketResponse(String protocol, String version, HttpResponseStatus status, String message) {
        super(false);
        this.protocol = protocol;
        this.version = version;
        this.status = status;
        this.message = message;
        this.headers = new LinkedList();
        this.cookies = new LinkedList();
        this.contentStream = null;
    }

    public HttpSocketResponse(String protocol, String version, String status, String message) {
        this(protocol, version, HttpResponseStatus.getStatus(message), message);
    }

    public HttpSocketResponse(String protocol, String version, int status, String message) {
        this(protocol, version, HttpResponseStatus.getStatus(message), message);
    }

    public HttpSocketResponse() {
        this("HTTP", "1.1", HttpResponseStatus.STATUS_200_OK, HttpResponseStatus.STATUS_200_OK.getMessage());
    }

    public String getProtocol() {
        return this.protocol == null ? "" : this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getVersion() {
        return this.version == null ? "" : this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public HttpResponseStatus getStatus() {
        return this.status;
    }

    public void setStatus(HttpResponseStatus status) {
        this.status = status;
        this.message = status == null ? "" : status.getMessage();
    }

    public String getMessage() {
        return this.message == null ? "" : this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public InputStream getContentStream() {
        return this.contentStream;
    }

    public void setContentStream(InputStream contentStream) {
        this.contentStream = contentStream;
    }

    public String getContentText(String charset, int bufferSize) throws IOException {
        ByteArrayOutputStream bufferStream = new ByteArrayOutputStream();
        if (this.contentStream != null) {
            while (this.contentStream.available() > 0) {
                int readSize = this.contentStream.available() > bufferSize ? bufferSize : this.contentStream.available();
                byte[] bytes = new byte[readSize];
                this.contentStream.read(bytes);
                bufferStream.write(bytes);
            }
        }
        return charset == null ? new String(bufferStream.toByteArray()) : new String(bufferStream.toByteArray(), charset);
    }

    public String getContentText(int bufferSize) throws IOException {
        return this.getContentText(null, bufferSize);
    }

    public String getContentText() throws IOException {
        return this.getContentText(null, SocketGlobal.DEFAULT_STREAM_BUFFER_SIZE);
    }

    public String getIdentifier() {
        StringBuffer buffer = new StringBuffer();
        if (!StringUtil.isEmpty((String)this.getProtocol())) {
            buffer.append(this.getProtocol());
            buffer.append("/");
        }
        if (!StringUtil.isEmpty((String)this.getVersion())) {
            buffer.append(this.getVersion());
            buffer.append(" ");
        }
        if (this.getStatus() != null) {
            buffer.append(this.getStatus().getCode());
            buffer.append(" ");
        }
        if (!StringUtil.isEmpty((String)this.getMessage())) {
            buffer.append(this.getMessage());
            buffer.append(" ");
        }
        return buffer.toString().trim();
    }

    public void setIdentifier(String identifier) {
        this.setProtocol(this.getProtocolByIdentifier(identifier));
        this.setVersion(this.getVersionByIdentifier(identifier));
        this.setStatus(this.getStatusByIdentifier(identifier));
        this.setMessage(this.getMessageByIdentifier(identifier));
    }

    private String getProtocolByIdentifier(String header) {
        if (header == null || header.length() == 0) {
            return null;
        }
        String[] values = header.split(" ", 3);
        if (values.length < 1) {
            return null;
        }
        String[] buffers = values[0].split("/", 2);
        if (buffers.length < 1) {
            return null;
        }
        return buffers[0];
    }

    private String getVersionByIdentifier(String header) {
        if (header == null || header.length() == 0) {
            return null;
        }
        String[] values = header.split(" ", 3);
        if (values.length < 1) {
            return null;
        }
        String[] buffers = values[0].split("/", 2);
        if (buffers.length < 2) {
            return null;
        }
        return buffers[1];
    }

    private HttpResponseStatus getStatusByIdentifier(String header) {
        if (header == null || header.length() == 0) {
            return null;
        }
        String[] values = header.split(" ", 3);
        if (values.length < 2) {
            return null;
        }
        return HttpResponseStatus.getStatus(values[1], this.getMessageByIdentifier(header));
    }

    private String getMessageByIdentifier(String header) {
        if (header == null || header.length() == 0) {
            return null;
        }
        String[] values = header.split(" ", 3);
        if (values.length < 3) {
            return null;
        }
        return values[2];
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("{");
        buffer.append("protocol=");
        buffer.append(this.getProtocol());
        buffer.append(",");
        buffer.append("version=");
        buffer.append(this.getVersion());
        buffer.append(",");
        buffer.append("status=");
        buffer.append(this.getStatus());
        buffer.append(",");
        buffer.append("message=");
        buffer.append(this.getMessage());
        buffer.append(",");
        buffer.append("headers=");
        buffer.append(this.getHeaders());
        buffer.append(",");
        buffer.append("cookies=");
        buffer.append(this.getCookies());
        buffer.append("}");
        return buffer.toString();
    }
}

