/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.socket.http.container;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.phosphoresce.commons.util.StringUtil;
import org.phosphoresce.socket.core.SocketGlobal;
import org.phosphoresce.socket.http.container.HttpSocketHeaderContainer;
import org.phosphoresce.socket.http.container.HttpSocketRequestPrameter;

public class HttpSocketRequest
extends HttpSocketHeaderContainer {
    private String method;
    private String path;
    private String protocol;
    private String version;
    private InputStream contentStream;

    public HttpSocketRequest(String method, String path, String protocol, String version) {
        super(true);
        this.method = method;
        this.path = path;
        this.protocol = protocol;
        this.version = version;
        this.contentStream = null;
    }

    public HttpSocketRequest() {
        this("GET", "/", "HTTP", "1.1");
    }

    public String getMethod() {
        return this.method == null ? "" : this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getPath() {
        return this.path == null ? "" : this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getProtocol() {
        return this.protocol == null ? "" : this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getVersion() {
        return this.version == null ? "" : this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public InputStream getContentStream() {
        return this.contentStream;
    }

    public void setContentStream(InputStream contentStream) {
        this.contentStream = contentStream;
    }

    public String getContentText(String charset, int bufferSize) throws IOException {
        ByteArrayOutputStream bufferStream = new ByteArrayOutputStream();
        if (this.contentStream != null) {
            while (this.contentStream.available() > 0) {
                int readSize = this.contentStream.available() > bufferSize ? bufferSize : this.contentStream.available();
                byte[] bytes = new byte[readSize];
                this.contentStream.read(bytes);
                bufferStream.write(bytes);
            }
        }
        return charset == null ? new String(bufferStream.toByteArray()) : new String(bufferStream.toByteArray(), charset);
    }

    public String getContentText(int bufferSize) throws IOException {
        return this.getContentText(null, bufferSize);
    }

    public String getContentText() throws IOException {
        return this.getContentText(null, SocketGlobal.DEFAULT_STREAM_BUFFER_SIZE);
    }

    public String getIdentifier() {
        StringBuffer buffer = new StringBuffer();
        if (!StringUtil.isEmpty((String)this.getMethod())) {
            buffer.append(this.getMethod());
            buffer.append(" ");
        }
        if (!StringUtil.isEmpty((String)this.getPath())) {
            buffer.append(this.getPath());
            buffer.append(" ");
        }
        if (!StringUtil.isEmpty((String)this.getProtocol())) {
            buffer.append(this.getProtocol());
            if (!StringUtil.isEmpty((String)this.getVersion())) {
                buffer.append("/");
                buffer.append(this.getVersion());
            }
        }
        return buffer.toString().trim();
    }

    public void setIdentifier(String identifier) {
        this.setMethod(this.getMethodByIdentifier(identifier));
        this.setPath(this.getPathByIdentifier(identifier));
        this.setProtocol(this.getProtocolByIdentifier(identifier));
        this.setVersion(this.getVersionByIdentifier(identifier));
    }

    private String getMethodByIdentifier(String header) {
        if (header == null || header.length() == 0) {
            return null;
        }
        String[] values = header.split(" ", 3);
        if (values.length < 1) {
            return null;
        }
        return values[0];
    }

    private String getPathByIdentifier(String header) {
        if (header == null || header.length() == 0) {
            return null;
        }
        String[] values = header.split(" ", 3);
        if (values.length < 2) {
            return null;
        }
        return values[1];
    }

    private String getProtocolByIdentifier(String header) {
        if (header == null || header.length() == 0) {
            return null;
        }
        String[] values = header.split(" ", 3);
        if (values.length < 3) {
            return null;
        }
        String[] buffers = values[2].split("/", 2);
        if (buffers.length < 1) {
            return null;
        }
        return buffers[0];
    }

    private String getVersionByIdentifier(String header) {
        if (header == null || header.length() == 0) {
            return null;
        }
        String[] values = header.split(" ", 3);
        if (values.length < 3) {
            return null;
        }
        String[] buffers = values[2].split("/", 2);
        if (buffers.length < 2) {
            return null;
        }
        return buffers[1];
    }

    public String getContextPath() {
        if (StringUtil.isEmpty((String)this.path)) {
            return "/";
        }
        String buffer = this.path.startsWith("/") ? this.path : "/" + this.path;
        return buffer.substring(1).indexOf("/") >= 0 ? buffer.substring(0, buffer.substring(1).indexOf("/") + 1) : buffer;
    }

    public String getResourcePath() {
        if (StringUtil.isEmpty((String)this.path)) {
            return "";
        }
        return this.path.substring(this.getContextPath().length());
    }

    public HttpSocketRequestPrameter getQueryParameter(String charset) {
        return HttpSocketRequestPrameter.createRequestParameter(charset, this.path.substring(this.path.indexOf("?") + 1));
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("{");
        buffer.append("method=");
        buffer.append(this.getMethod());
        buffer.append(",");
        buffer.append("path=");
        buffer.append(this.getPath());
        buffer.append(",");
        buffer.append("protocol=");
        buffer.append(this.getProtocol());
        buffer.append(",");
        buffer.append("version=");
        buffer.append(this.getVersion());
        buffer.append(",");
        buffer.append("headers=");
        buffer.append(this.getHeaders());
        buffer.append(",");
        buffer.append("cookies=");
        buffer.append(this.getCookies());
        buffer.append("}");
        return buffer.toString();
    }
}

