/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.socket.http.container;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.phosphoresce.commons.util.StringUtil;
import org.phosphoresce.socket.http.container.HttpSocketCookie;
import org.phosphoresce.socket.http.container.HttpSocketHeader;

abstract class HttpSocketHeaderContainer
implements Serializable {
    protected static final String HEADER_KEY_REQUEST_COOKIE = "Cookie";
    protected static final String HEADER_KEY_RESPONSE_COOKIE = "Set-Cookie";
    private boolean requestContainer;
    private List headers = new LinkedList();
    private List cookies = new LinkedList();

    public HttpSocketHeaderContainer(boolean requestContainer) {
        this.requestContainer = requestContainer;
    }

    private HttpSocketHeaderContainer() {
        this(true);
    }

    protected List getHeaders() {
        return this.headers;
    }

    protected void setHeaders(List headers) {
        this.headers = headers;
    }

    protected List getCookies() {
        return this.cookies;
    }

    protected void setCookies(List cookies) {
        this.cookies = cookies;
    }

    private String getHeaderCookieKey() {
        return this.requestContainer ? HEADER_KEY_REQUEST_COOKIE : HEADER_KEY_RESPONSE_COOKIE;
    }

    private String getHeaderKeyOfHeaderString(String headerString) {
        if (StringUtil.isEmpty((String)headerString)) {
            return "";
        }
        String[] tokens = headerString.split(":", 2);
        return tokens.length > 0 ? tokens[0].trim() : "";
    }

    private String getHeaderValueOfHeaderString(String headerString) {
        if (StringUtil.isEmpty((String)headerString)) {
            return "";
        }
        String[] tokens = headerString.split(":", 2);
        return tokens.length > 1 ? tokens[1].trim() : "";
    }

    private boolean isCookieHeader(String headerString) {
        return this.getHeaderCookieKey().equals(this.getHeaderKeyOfHeaderString(headerString));
    }

    private String getCookieKeyOfCookieString(String cookieString) {
        if (StringUtil.isEmpty((String)cookieString)) {
            return "";
        }
        String[] tokens = cookieString.split("=", 2);
        return tokens.length > 0 ? tokens[0].trim() : "";
    }

    private String getCookieValueOfCookieString(String cookieString) {
        if (StringUtil.isEmpty((String)cookieString)) {
            return "";
        }
        String[] tokens = cookieString.split("=", 2);
        return tokens.length > 1 ? tokens[1].trim() : "";
    }

    public void addHeader(String name, String value) {
        if (this.getHeaderCookieKey().equals(name)) {
            this.addCookie(value);
        } else {
            HttpSocketHeader header = new HttpSocketHeader();
            header.setName(name);
            header.setValue(value);
            this.headers.add(header);
        }
    }

    public void addHeader(String name, int value) {
        this.addHeader(name, String.valueOf(value));
    }

    public void addHeader(String name, long value) {
        this.addHeader(name, String.valueOf(value));
    }

    public void addHeader(String headerString) {
        if (StringUtil.isEmpty((String)headerString)) {
            return;
        }
        this.addHeader(this.getHeaderKeyOfHeaderString(headerString), this.getHeaderValueOfHeaderString(headerString));
    }

    public void putHeader(String name, String value) {
        this.removeHeader(name);
        this.addHeader(name, value);
    }

    public void putHeader(String name, int value) {
        this.removeHeader(name);
        this.addHeader(name, value);
    }

    public void putHeader(String name, long value) {
        this.removeHeader(name);
        this.addHeader(name, value);
    }

    public void putHeader(String headerString) {
        if (StringUtil.isEmpty((String)headerString)) {
            return;
        }
        this.removeHeader(this.getHeaderKeyOfHeaderString(headerString));
        this.addHeader(headerString);
    }

    public void removeHeader(String name) {
        while (this.containsHeader(name)) {
            HttpSocketHeader header = this.getHeader(name);
            this.headers.remove(header);
        }
    }

    public boolean containsHeader(String name) {
        return this.getHeader(name) != null;
    }

    public HttpSocketHeader getHeader(String name) {
        Iterator iterator = this.headers.iterator();
        while (iterator.hasNext()) {
            HttpSocketHeader header = (HttpSocketHeader)iterator.next();
            if (!header.getName().equalsIgnoreCase(name)) continue;
            return header;
        }
        return null;
    }

    public String getHeaderValueOfString(String name) {
        HttpSocketHeader header = this.getHeader(name);
        return header == null ? "" : header.getValue();
    }

    public int getHeaderValueOfInteger(String name) {
        HttpSocketHeader header = this.getHeader(name);
        return header == null ? -1 : header.getValueOfInteger();
    }

    public long getHeaderValueOfLong(String name) {
        HttpSocketHeader header = this.getHeader(name);
        return header == null ? -1L : header.getValueOfLong();
    }

    public String[] getHeaderStrings() {
        LinkedList<String> list = new LinkedList<String>();
        Iterator iterator = this.headers.iterator();
        while (iterator.hasNext()) {
            HttpSocketHeader header = (HttpSocketHeader)iterator.next();
            list.add(header.getHeaderString());
        }
        return list.toArray(new String[list.size()]);
    }

    public void addCookie(String cookieString) {
        if (StringUtil.isEmpty((String)cookieString)) {
            return;
        }
        if (this.requestContainer) {
            String[] tokens = cookieString.split(";");
            for (int i = 0; i <= tokens.length - 1; ++i) {
                String token = tokens[i].trim();
                HttpSocketCookie cookie = new HttpSocketCookie();
                cookie.setCookieString(token);
                this.cookies.add(cookie);
            }
        } else {
            HttpSocketCookie cookie = new HttpSocketCookie();
            cookie.setCookieString(cookieString);
            this.cookies.add(cookie);
        }
    }

    public void addCookie(String name, String value, Date expires, String path, String domain, boolean secure) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(name == null ? "" : name);
        buffer.append("=");
        buffer.append(value == null ? "" : value);
        if (expires != null) {
            buffer.append("; ");
            buffer.append("expires=");
            buffer.append(new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH).format(expires));
        }
        if (path != null) {
            buffer.append("; ");
            buffer.append("path=");
            buffer.append(path);
        }
        if (domain != null) {
            buffer.append("; ");
            buffer.append("domain=");
            buffer.append(domain);
        }
        if (secure) {
            buffer.append("; ");
            buffer.append("secure");
        }
        this.addCookie(buffer.toString());
    }

    public void addCookie(String name, String value) {
        this.addCookie(name, value, null, null, null, false);
    }

    public void putCookie(String cookieString) {
        if (StringUtil.isEmpty((String)cookieString)) {
            return;
        }
        if (this.requestContainer) {
            String[] tokens = cookieString.split(";");
            for (int i = 0; i <= tokens.length - 1; ++i) {
                String token = tokens[i].trim();
                this.removeCookie(this.getCookieKeyOfCookieString(token));
                HttpSocketCookie cookie = new HttpSocketCookie();
                cookie.setCookieString(token);
                this.cookies.add(cookie);
            }
        } else {
            this.removeCookie(this.getCookieKeyOfCookieString(cookieString));
            HttpSocketCookie cookie = new HttpSocketCookie();
            cookie.setCookieString(cookieString);
            this.cookies.add(cookie);
        }
    }

    public void putCookie(String name, String value, Date expires, String path, String domain, boolean secure) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(name == null ? "" : value);
        buffer.append("=");
        buffer.append(value == null ? "" : value);
        if (expires != null) {
            buffer.append("; ");
            buffer.append("expires=");
            buffer.append(new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH).format(expires));
        }
        if (path != null) {
            buffer.append("; ");
            buffer.append("path=");
            buffer.append(path);
        }
        if (domain != null) {
            buffer.append("; ");
            buffer.append("domain=");
            buffer.append(domain);
        }
        if (secure) {
            buffer.append("; ");
            buffer.append("secure");
        }
        this.putCookie(buffer.toString());
    }

    public void putCookie(String name, String value) {
        this.putCookie(name, value, null, null, null, false);
    }

    public void removeCookie(String name) {
        HttpSocketCookie[] cookies = this.getCookies(name);
        for (int i = 0; i <= cookies.length - 1; ++i) {
            this.cookies.remove(cookies[i]);
        }
    }

    public boolean containsCookie(String name) {
        return this.getCookieCountOf(name) > 0;
    }

    public int getCookieCountOf(String name) {
        return this.getCookies(name).length;
    }

    public HttpSocketCookie[] getCookies(String name) {
        LinkedList<HttpSocketCookie> list = new LinkedList<HttpSocketCookie>();
        Iterator iterator = this.cookies.iterator();
        while (iterator.hasNext()) {
            HttpSocketCookie cookie = (HttpSocketCookie)iterator.next();
            if (!cookie.getName().equalsIgnoreCase(name)) continue;
            list.add(cookie);
        }
        return list.toArray(new HttpSocketCookie[list.size()]);
    }

    public HttpSocketCookie getCookie(String name) {
        HttpSocketCookie[] cookies = this.getCookies(name);
        return cookies.length <= 0 ? null : cookies[cookies.length - 1];
    }

    public String getCookieValueOfString(String name) {
        HttpSocketCookie cookie = this.getCookie(name);
        return cookie == null ? "" : cookie.getValue();
    }

    public int getCookieValueOfInteger(String name) {
        HttpSocketCookie cookie = this.getCookie(name);
        return cookie == null ? -1 : cookie.getValueOfInteger();
    }

    public long getCookieValueOfLong(String name) {
        HttpSocketCookie cookie = this.getCookie(name);
        return cookie == null ? -1L : cookie.getValueOfLong();
    }

    public String[] getCookieStrings() {
        LinkedList<String> list = new LinkedList<String>();
        if (this.cookies.size() == 0) {
            return new String[0];
        }
        if (this.requestContainer) {
            StringBuffer cookieBuffer = new StringBuffer();
            Iterator iterator = this.cookies.iterator();
            while (iterator.hasNext()) {
                HttpSocketCookie cookie = (HttpSocketCookie)iterator.next();
                cookieBuffer.append(cookie.getCookieString());
                cookieBuffer.append("; ");
            }
            String cookieString = cookieBuffer.toString().trim();
            cookieString = cookieString.endsWith(";") ? cookieString.substring(0, cookieString.length() - 1) : cookieString;
            list.add(this.getHeaderCookieKey() + ": " + cookieString);
        } else {
            Iterator iterator = this.cookies.iterator();
            while (iterator.hasNext()) {
                HttpSocketCookie cookie = (HttpSocketCookie)iterator.next();
                list.add(this.getHeaderCookieKey() + ": " + cookie.getCookieString());
            }
        }
        return list.toArray(new String[list.size()]);
    }

    public int getContentLength() {
        return this.getHeaderValueOfInteger("Content-Length");
    }

    public void setContentLength(long length) {
        if (length < 0L) {
            this.removeHeader("Content-Length");
        } else {
            this.addHeader("Content-Length", length);
        }
    }

    public boolean isChunkedContent() {
        return "chunked".equalsIgnoreCase(this.getHeaderValueOfString("Transfer-Encoding"));
    }

    public boolean isKeepAliveConnection() {
        return "keep-alive".equalsIgnoreCase(this.getHeaderValueOfString("Connection"));
    }
}

