/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.commons.util;

import java.io.File;
import java.util.Locale;
import org.phosphoresce.commons.util.CommandResult;
import org.phosphoresce.commons.util.CommandUtil;

public final class KeytoolUtil {
    public static final String COMMAND_KEYTOOL = System.getProperty("java.home") + File.separator + "bin" + File.separator + "keytool";

    private KeytoolUtil() {
    }

    public static boolean isExistKeyStore(String keystore) {
        File file = new File(keystore);
        return file.exists() && file.isFile();
    }

    public static CommandResult genkey(String alias, String keyalg, int keysize, String keypass, int validity, String storetype, String keystore, String storepass, String cn, String ou, String o, String c) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(COMMAND_KEYTOOL);
        buffer.append(" -genkey ");
        buffer.append(" -alias ").append(alias);
        buffer.append(" -keyalg ").append(keyalg);
        buffer.append(" -keysize ").append(keysize);
        buffer.append(" -keypass ").append(keypass);
        buffer.append(" -validity ").append(validity);
        buffer.append(" -storetype ").append(storetype);
        buffer.append(" -keystore ").append(keystore);
        buffer.append(" -storepass ").append(storepass);
        buffer.append(" -dname ");
        buffer.append("\"");
        buffer.append("cn=").append(cn);
        buffer.append(",");
        buffer.append("ou=").append(ou);
        buffer.append(",");
        buffer.append("o=").append(o);
        buffer.append(",");
        buffer.append("c=").append(c);
        buffer.append("\"");
        return CommandUtil.execAndWait(buffer.toString());
    }

    public static CommandResult genkey(String alias, String keypass, String keystore, String storepass, String cn, String ou, String o) {
        return KeytoolUtil.genkey(alias, "RSA", 512, keypass, 365, "JKS", keystore, storepass, cn, ou, o, Locale.getDefault().getCountry());
    }
}

