/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.commons.util;

import java.io.IOException;
import java.io.Serializable;

public class ByteFIFOStack
implements Serializable {
    protected int maxSize;
    protected int nowSize;
    protected byte[] stack;

    private ByteFIFOStack() {
    }

    public ByteFIFOStack(int maxSize) {
        this.maxSize = maxSize < 0 ? 0 : maxSize;
        this.nowSize = 0;
        this.stack = new byte[maxSize < 0 ? 0 : maxSize];
    }

    public byte[] push(int b) throws IOException {
        return this.push(new byte[]{(byte)b}, 0, 1);
    }

    public byte[] push(byte[] bytes, int offset, int length) throws IOException {
        byte[] buffer = new byte[this.nowSize + length];
        System.arraycopy(this.stack, 0, buffer, 0, this.nowSize);
        System.arraycopy(bytes, offset, buffer, this.nowSize, length);
        if (buffer.length - this.maxSize >= 0) {
            byte[] result = new byte[buffer.length - this.maxSize];
            System.arraycopy(buffer, 0, result, 0, result.length);
            this.stack = new byte[this.maxSize];
            System.arraycopy(buffer, result.length, this.stack, 0, buffer.length - result.length);
            this.nowSize = this.nowSize + length > this.maxSize ? this.maxSize : this.nowSize + length;
            return result;
        }
        this.stack = new byte[this.maxSize];
        System.arraycopy(buffer, 0, this.stack, 0, buffer.length);
        this.nowSize = buffer.length;
        return new byte[0];
    }

    public byte[] push(byte[] bytes) throws IOException {
        return this.push(bytes, 0, bytes.length);
    }

    public byte[] pop(int length) throws IOException {
        length = length > this.nowSize ? this.nowSize : length;
        byte[] result = new byte[length];
        byte[] buffer = new byte[this.maxSize];
        System.arraycopy(this.stack, 0, result, 0, length);
        this.nowSize -= length;
        System.arraycopy(this.stack, length, buffer, 0, this.maxSize - length);
        this.stack = buffer;
        return result;
    }

    public byte[] pop() throws IOException {
        return this.pop(1);
    }

    public byte[] popAll() throws IOException {
        return this.pop(this.nowSize);
    }

    public void clear() {
        this.nowSize = 0;
        this.stack = new byte[this.maxSize];
    }

    public byte[] getBytes() {
        byte[] result = new byte[this.nowSize];
        System.arraycopy(this.stack, 0, result, 0, this.nowSize);
        return result;
    }
}

