/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.commons.ldaps;

import java.util.LinkedList;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.phosphoresce.commons.ldaps.LDAPAttribute;
import org.phosphoresce.commons.ldaps.LDAPEntry;
import org.phosphoresce.commons.ldaps.LDAPManagerConfig;

public class LDAPManager {
    public static final String FILTER_SEARCH_ALL = "(objectClass=*)";
    private LDAPManagerConfig config;
    private DirContext context;
    private SearchControls controls;

    private LDAPManager() {
    }

    public LDAPManager(LDAPManagerConfig config) {
        this.config = config;
    }

    public void close() throws NamingException {
        if (this.context != null) {
            this.context.close();
            this.context = null;
        }
    }

    public boolean isClosed() {
        return this.context == null;
    }

    protected DirContext getContext() throws NamingException {
        if (this.context == null) {
            this.context = this.config.createContext();
        }
        return this.context;
    }

    protected SearchControls getSearchControls() {
        if (this.controls == null) {
            this.controls = this.config.createSearchControls();
        }
        return this.controls;
    }

    public LDAPEntry[] search(String dn, String filter) throws NamingException {
        DirContext context = this.getContext();
        SearchControls controls = this.getSearchControls();
        LinkedList<LDAPEntry> resultList = new LinkedList<LDAPEntry>();
        NamingEnumeration<SearchResult> results = context.search(dn, filter, controls);
        while (results.hasMore()) {
            SearchResult result = results.next();
            Attributes attributes = result.getAttributes();
            resultList.add(LDAPEntry.createEntry(attributes));
        }
        return resultList.toArray(new LDAPEntry[resultList.size()]);
    }

    public LDAPEntry[] searchAll(String dn) throws NamingException {
        return this.search(dn, FILTER_SEARCH_ALL);
    }

    public int count(String dn, String filter) throws NamingException {
        return this.search(dn, filter).length;
    }

    public int countAll(String dn) throws NamingException {
        return this.searchAll(dn).length;
    }

    public void add(String dn, LDAPEntry entry) throws NamingException {
        DirContext context = this.getContext();
        SearchControls controls = this.getSearchControls();
        context.createSubcontext(dn, (Attributes)entry.createBasicAttributes());
    }

    public void update(String dn, LDAPEntry entry) throws NamingException {
        DirContext context = this.getContext();
        SearchControls controls = this.getSearchControls();
        LDAPAttribute[] attributes = entry.getAttributes();
        LinkedList<ModificationItem> itemList = new LinkedList<ModificationItem>();
        for (int i = 0; i <= attributes.length - 1; ++i) {
            LDAPAttribute attribute = attributes[i];
            BasicAttribute namingAtrribute = attribute.createBasicAttribute();
            itemList.add(new ModificationItem(2, namingAtrribute));
        }
        context.modifyAttributes(dn, itemList.toArray(new ModificationItem[itemList.size()]));
    }

    public void delete(String dn) throws NamingException {
        DirContext context = this.getContext();
        SearchControls controls = this.getSearchControls();
        context.destroySubcontext(dn);
    }
}

