/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.commons.ldaps;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import org.phosphoresce.commons.ldaps.LDAPAttribute;

public class LDAPEntry
implements Serializable {
    private Map data = new LinkedHashMap();
    private boolean ignoreCase = false;

    public static LDAPEntry createEntry(Attributes attributes) throws NamingException {
        LDAPEntry entry = new LDAPEntry();
        entry.ignoreCase = attributes.isCaseIgnored();
        NamingEnumeration<? extends Attribute> enumeration = attributes.getAll();
        while (enumeration.hasMore()) {
            Attribute attribute = enumeration.next();
            LDAPAttribute ldapAttribute = LDAPAttribute.createAttribute(attribute);
            entry.addAttribute(ldapAttribute);
        }
        return entry;
    }

    public BasicAttributes createBasicAttributes() {
        BasicAttributes attributes = new BasicAttributes();
        Iterator iterator = this.data.keySet().iterator();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            LDAPAttribute attribute = (LDAPAttribute)this.data.get(name);
            attributes.put(attribute.createBasicAttribute());
        }
        return attributes;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public boolean containsAttribute(String name) {
        return this.data.containsKey(name);
    }

    public void addAttribute(LDAPAttribute attribute) {
        String name = attribute.getName();
        Iterator iterator = attribute.getValues().iterator();
        while (iterator.hasNext()) {
            Object value = iterator.next();
            this.addAttribute(name, value);
        }
    }

    public void addAttribute(String name, Object value) {
        if (!this.containsAttribute(name)) {
            LDAPAttribute attribute = new LDAPAttribute(name);
            attribute.addValue(value);
            this.data.put(name, attribute);
        } else {
            LDAPAttribute attribute = this.getAttribute(name);
            attribute.addValue(value);
        }
    }

    public LDAPAttribute getAttribute(String name) {
        return (LDAPAttribute)this.data.get(name);
    }

    public LDAPAttribute[] getAttributes() {
        Collection collection = this.data.values();
        return collection.toArray(new LDAPAttribute[collection.size()]);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.data);
        return buffer.toString();
    }
}

