/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.commons.ldaps;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.BasicAttribute;

public class LDAPAttribute
implements Serializable {
    private String name;
    private List values;

    public LDAPAttribute(String name) {
        this.name = name;
        this.values = new LinkedList();
    }

    private LDAPAttribute() {
        this(null);
    }

    public static LDAPAttribute createAttribute(Attribute attribute) throws NamingException {
        LDAPAttribute ldapAttribute = new LDAPAttribute(attribute.getID());
        NamingEnumeration<?> enumeration = attribute.getAll();
        while (enumeration.hasMore()) {
            Object object = enumeration.next();
            ldapAttribute.addValue(object);
        }
        return ldapAttribute;
    }

    public BasicAttribute createBasicAttribute() {
        BasicAttribute attribute = new BasicAttribute(this.name);
        Iterator iterator = this.values.iterator();
        while (iterator.hasNext()) {
            attribute.add(iterator.next());
        }
        return attribute;
    }

    public String getName() {
        return this.name;
    }

    public List getValues() {
        return this.values;
    }

    public Object getValue(int index) {
        return this.values.get(index);
    }

    public void clearValues() {
        this.values.clear();
    }

    public int getValueCount() {
        return this.values.size();
    }

    public void addValue(Object value) {
        this.values.add(value);
    }

    public void setValue(int index, Object value) {
        this.values.set(index, value);
    }

    public boolean containsValue(String value) {
        return this.values.contains(value);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("{");
        buffer.append("name=");
        buffer.append(this.name);
        buffer.append(",");
        buffer.append("values=");
        buffer.append(this.values);
        buffer.append("}");
        return buffer.toString();
    }
}

