/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.commons.io;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.phosphoresce.commons.util.ByteFIFOStack;
import org.phosphoresce.commons.util.StringUtil;

public class ReplacableOutputStream
extends OutputStream {
    private OutputStream stream;
    private ByteFIFOStack stack;
    private boolean regexp;
    private int regexpSize;
    private String match;
    private String replace;

    private ReplacableOutputStream() {
    }

    public ReplacableOutputStream(OutputStream stream, String match, String replace, boolean regexp, int regexpSize) {
        this.stream = new BufferedOutputStream(stream);
        this.stack = new ByteFIFOStack(match == null ? 0 : (regexp ? (regexpSize < 0 ? 0 : regexpSize) : match.getBytes().length));
        this.regexpSize = regexpSize < 0 ? 0 : regexpSize;
        this.match = match == null ? "" : match;
        this.replace = replace == null ? "" : replace;
        this.regexp = regexp;
    }

    public ReplacableOutputStream(OutputStream stream, String match, String replace) {
        this(stream, match, replace, false, -1);
    }

    public void write(int data) throws IOException {
        if (StringUtil.isEmpty(this.match)) {
            this.stream.write(data);
        } else {
            byte[] bytes = this.stack.push(data);
            if (bytes.length > 0) {
                this.stream.write(bytes);
            }
            boolean matched = false;
            String stackedValue = new String(this.stack.getBytes());
            if (this.regexp) {
                if (stackedValue.matches(this.match)) {
                    stackedValue = stackedValue.replaceAll(this.match, this.replace);
                    this.stream.write(stackedValue.getBytes());
                    this.stack.clear();
                }
            } else if (this.match.equals(stackedValue)) {
                stackedValue = StringUtil.replace(stackedValue, this.match, this.replace);
                this.stream.write(stackedValue.getBytes());
                this.stack.clear();
            }
        }
    }

    public void close() throws IOException {
        this.flush();
        this.stream.close();
    }

    public void flush() throws IOException {
        this.stream.write(this.stack.popAll());
        this.stream.flush();
    }
}

