/*
 * Decompiled with CFR 0.152.
 */
package org.phosphoresce.commons.html.util;

import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import org.phosphoresce.commons.html.HTMLCommentElement;
import org.phosphoresce.commons.html.HTMLDocumentElement;
import org.phosphoresce.commons.html.HTMLElement;
import org.phosphoresce.commons.html.HTMLTagElement;
import org.phosphoresce.commons.html.HTMLTextElement;

public class HTMLDocumentParserCallbak
extends HTMLEditorKit.ParserCallback {
    private HTMLDocumentElement document = new HTMLDocumentElement();
    private HTMLElement current = this.document;

    public HTMLDocumentElement getDocument() {
        return this.document;
    }

    public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet attribute, int pos) {
        HTMLTagElement newElement = new HTMLTagElement(tag, attribute.copyAttributes());
        this.current.addChild(newElement);
        super.handleSimpleTag(tag, attribute, pos);
    }

    public void handleStartTag(HTML.Tag tag, MutableAttributeSet attribute, int pos) {
        HTMLTagElement newElement = new HTMLTagElement(tag, attribute.copyAttributes());
        this.current.addChild(newElement);
        this.current = newElement;
        super.handleStartTag(tag, attribute, pos);
    }

    public void handleEndTag(HTML.Tag tag, int pos) {
        if (!this.current.isRoot() && this.current instanceof HTMLTagElement && ((HTMLTagElement)this.current).getName().equals(tag.toString())) {
            this.current = this.current.getParent();
        }
        super.handleEndTag(tag, pos);
    }

    public void handleComment(char[] data, int pos) {
        HTMLCommentElement newElement = new HTMLCommentElement(new String(data));
        this.current.addChild(newElement);
        super.handleComment(data, pos);
    }

    public void handleEndOfLineString(String eol) {
        if (!this.current.equals(this.document)) {
            // empty if block
        }
        super.handleEndOfLineString(eol);
    }

    public void handleError(String message, int pos) {
        super.handleError(message, pos);
    }

    public void handleText(char[] data, int pos) {
        HTMLTextElement newElement = new HTMLTextElement(new String(data));
        this.current.addChild(newElement);
        super.handleText(data, pos);
    }
}

