/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.web.servlets;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.ReportContext;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;
import net.sf.jasperreports.engine.export.JRXhtmlExporter;
import net.sf.jasperreports.web.JRInteractiveException;
import net.sf.jasperreports.web.WebReportContext;
import net.sf.jasperreports.web.actions.AbstractAction;
import net.sf.jasperreports.web.actions.Action;
import net.sf.jasperreports.web.actions.MultiAction;
import net.sf.jasperreports.web.servlets.AbstractServlet;
import net.sf.jasperreports.web.servlets.Controller;
import net.sf.jasperreports.web.servlets.JasperPrintAccessor;
import net.sf.jasperreports.web.servlets.ReportExecutionStatus;
import net.sf.jasperreports.web.servlets.ReportPageStatus;
import net.sf.jasperreports.web.util.JacksonUtil;
import net.sf.jasperreports.web.util.ReportExecutionHyperlinkProducerFactory;
import net.sf.jasperreports.web.util.VelocityUtil;
import net.sf.jasperreports.web.util.WebUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReportServlet
extends AbstractServlet {
    private static final long serialVersionUID = 10200L;
    private static final Log log = LogFactory.getLog(ReportServlet.class);
    private static final String TEMPLATE_HEADER = "net/sf/jasperreports/web/servlets/resources/templates/HeaderTemplate.vm";
    private static final String TEMPLATE_BETWEEN_PAGES = "net/sf/jasperreports/web/servlets/resources/templates/BetweenPagesTemplate.vm";
    private static final String TEMPLATE_FOOTER = "net/sf/jasperreports/web/servlets/resources/templates/FooterTemplate.vm";
    private static final String TEMPLATE_HEADER_NOPAGES = "net/sf/jasperreports/web/servlets/resources/templates/HeaderTemplateNoPages.vm";
    private static final String TEMPLATE_FOOTER_NOPAGES = "net/sf/jasperreports/web/servlets/resources/templates/FooterTemplateNoPages.vm";
    private static final String REQUEST_PARAMETER_IGNORE_PAGINATION = "jr.ignrpg";
    private static final String REQUEST_PARAMETER_ACTION = "jr.action";
    private static final String REQUEST_PARAMETER_PAGE = "jr.page";
    private static final String REQUEST_PARAMETER_PAGE_TIMESTAMP = "jr.pagetimestamp";

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        response.setContentType("text/html; charset=UTF-8");
        response.setHeader("Expires", "Sat, 6 May 1995 12:00:00 GMT");
        response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        response.addHeader("Cache-Control", "post-check=0, pre-check=0");
        response.setHeader("Pragma", "no-cache");
        PrintWriter out = response.getWriter();
        WebReportContext webReportContext = WebReportContext.getInstance(request);
        try {
            this.runReport(request, webReportContext);
            this.render(request, webReportContext, out);
        }
        catch (JRInteractiveException e) {
            log.error((Object)"Jasper Interactive error", (Throwable)e);
            out.println("<div><pre id=\"jrInteractiveError\">");
            out.println(e.getMessage());
            out.println("</pre></div>");
        }
        catch (Exception e) {
            log.error((Object)"Error on report execution", (Throwable)e);
            out.println("<html>");
            out.println("<head>");
            out.println("<title>JasperReports - Web Application Sample</title>");
            out.println("<link rel=\"stylesheet\" type=\"text/css\" href=\"../stylesheet.css\" title=\"Style\">");
            out.println("<body bgcolor=\"white\">");
            out.println("<span class=\"bnew\">JasperReports encountered this error :</span>");
            out.println("<pre>");
            e.printStackTrace(out);
            out.println("</pre>");
            out.println("</body>");
            out.println("</html>");
        }
    }

    public void runReport(HttpServletRequest request, WebReportContext webReportContext) throws JRException, JRInteractiveException {
        JasperPrintAccessor jasperPrintAccessor = (JasperPrintAccessor)webReportContext.getParameterValue("net.sf.jasperreports.web.jasper_print.accessor");
        JRPropertiesUtil propUtil = JRPropertiesUtil.getInstance(this.getJasperReportsContext());
        String runReportParamName = propUtil.getProperty("net.sf.jasperreports.web.request.parameter.run.report");
        String runReport = request.getParameter(runReportParamName);
        if (jasperPrintAccessor == null || Boolean.valueOf(runReport).booleanValue()) {
            String asyncParamName;
            String async;
            Boolean isIgnorePagination;
            String reportUriParamName = propUtil.getProperty("net.sf.jasperreports.web.request.parameter.report.uri");
            String reportUri = request.getParameter(reportUriParamName);
            if (reportUri != null) {
                webReportContext.setParameterValue(reportUriParamName, reportUri);
            }
            if ((isIgnorePagination = Boolean.valueOf(request.getParameter(REQUEST_PARAMETER_IGNORE_PAGINATION))) != null) {
                webReportContext.setParameterValue("IS_IGNORE_PAGINATION", isIgnorePagination);
            }
            if ((async = request.getParameter(asyncParamName = propUtil.getProperty("net.sf.jasperreports.web.request.parameter.async.report"))) != null) {
                webReportContext.setParameterValue(asyncParamName, Boolean.valueOf(async));
            }
            Action action = this.getAction(webReportContext, WebUtil.decodeUrl(request.getParameter(REQUEST_PARAMETER_ACTION)));
            Controller controller = new Controller(this.getJasperReportsContext());
            controller.runReport(webReportContext, action);
        }
    }

    public void render(HttpServletRequest request, WebReportContext webReportContext, PrintWriter writer) throws JRException {
        ReportPageStatus pageStatus;
        JasperPrintAccessor jasperPrintAccessor = (JasperPrintAccessor)webReportContext.getParameterValue("net.sf.jasperreports.web.jasper_print.accessor");
        ReportExecutionStatus reportStatus = jasperPrintAccessor.getReportStatus();
        if (reportStatus.getStatus() == ReportExecutionStatus.Status.ERROR) {
            throw new JRRuntimeException("Error occurred during report generation", reportStatus.getError());
        }
        boolean hasPages = jasperPrintAccessor.pageStatus(0, null).pageExists();
        JRXhtmlExporter exporter = new JRXhtmlExporter(this.getJasperReportsContext());
        if (hasPages) {
            String pageTimestamp;
            Long timestamp;
            String reportPage = request.getParameter(REQUEST_PARAMETER_PAGE);
            int pageIdx = reportPage == null ? 0 : Integer.parseInt(reportPage);
            pageStatus = jasperPrintAccessor.pageStatus(pageIdx, timestamp = (pageTimestamp = request.getParameter(REQUEST_PARAMETER_PAGE_TIMESTAMP)) == null ? null : Long.valueOf(pageTimestamp));
            if (!pageStatus.pageExists()) {
                throw new JRRuntimeException("Page " + pageIdx + " not found in report");
            }
            exporter.setParameter(JRExporterParameter.PAGE_INDEX, pageIdx);
        } else {
            pageStatus = ReportPageStatus.PAGE_FINAL;
        }
        exporter.setReportContext(webReportContext);
        exporter.setParameter(JRExporterParameter.JASPER_PRINT, jasperPrintAccessor.getJasperPrint());
        exporter.setParameter(JRExporterParameter.OUTPUT_WRITER, writer);
        exporter.setParameter(JRHtmlExporterParameter.IMAGES_URI, "image?jr.ctxid=" + webReportContext.getId() + "&image=");
        exporter.setParameter(JRHtmlExporterParameter.HTML_HEADER, this.getHeader(request, webReportContext, hasPages, pageStatus));
        exporter.setParameter(JRHtmlExporterParameter.BETWEEN_PAGES_HTML, this.getBetweenPages(request, webReportContext));
        exporter.setParameter(JRHtmlExporterParameter.HTML_FOOTER, this.getFooter(request, webReportContext, hasPages, pageStatus));
        exporter.setParameter(JRHtmlExporterParameter.HYPERLINK_PRODUCER_FACTORY, ReportExecutionHyperlinkProducerFactory.getInstance(this.getJasperReportsContext(), request));
        exporter.exportReport();
    }

    protected String getHeader(HttpServletRequest request, WebReportContext webReportContext, boolean hasPages, ReportPageStatus pageStatus) {
        HashMap<String, Object> contextMap = new HashMap<String, Object>();
        JasperPrintAccessor jasperPrintAccessor = (JasperPrintAccessor)webReportContext.getParameterValue("net.sf.jasperreports.web.jasper_print.accessor");
        contextMap.put("totalPages", jasperPrintAccessor.getReportStatus().getTotalPageCount());
        String reportPage = request.getParameter(REQUEST_PARAMETER_PAGE);
        contextMap.put("currentPage", reportPage != null ? reportPage : "0");
        if (!pageStatus.isPageFinal()) {
            contextMap.put("pageTimestamp", String.valueOf(pageStatus.getTimestamp()));
        }
        if (hasPages) {
            return VelocityUtil.processTemplate(TEMPLATE_HEADER, contextMap);
        }
        return VelocityUtil.processTemplate(TEMPLATE_HEADER_NOPAGES, contextMap);
    }

    protected String getBetweenPages(HttpServletRequest request, WebReportContext webReportContext) {
        return VelocityUtil.processTemplate(TEMPLATE_BETWEEN_PAGES, new HashMap<String, Object>());
    }

    protected String getFooter(HttpServletRequest request, WebReportContext webReportContext, boolean hasPages, ReportPageStatus pageStatus) {
        HashMap<String, Object> contextMap = new HashMap<String, Object>();
        if (hasPages) {
            return VelocityUtil.processTemplate(TEMPLATE_FOOTER, contextMap);
        }
        return VelocityUtil.processTemplate(TEMPLATE_FOOTER_NOPAGES, contextMap);
    }

    private Action getAction(ReportContext webReportContext, String jsonData) {
        Action result = null;
        List<AbstractAction> actions = JacksonUtil.getInstance(this.getJasperReportsContext()).loadAsList(jsonData, AbstractAction.class);
        if (actions != null) {
            if (actions.size() == 1) {
                result = actions.get(0);
            } else if (actions.size() > 1) {
                result = new MultiAction(actions);
            }
            ((AbstractAction)result).init(this.getJasperReportsContext(), webReportContext);
        }
        return result;
    }
}

