/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.base.JRBaseElementGroup;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;

public class JRDesignElementGroup
extends JRBaseElementGroup
implements JRChangeEventsSupport {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_ELEMENT_GROUP = "elementGroup";
    public static final String PROPERTY_CHILDREN = "children";
    private transient JRPropertyChangeSupport eventSupport;

    public void setElementGroup(JRElementGroup elementGroup) {
        JRElementGroup old = this.elementGroup;
        this.elementGroup = elementGroup;
        this.getEventSupport().firePropertyChange(PROPERTY_ELEMENT_GROUP, old, this.elementGroup);
    }

    public void addElement(JRDesignElement element) {
        this.addElement(this.children.size(), element);
    }

    public void addElement(int index, JRDesignElement element) {
        element.setElementGroup(this);
        this.children.add(index, element);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_CHILDREN, element, index);
    }

    public JRDesignElement removeElement(JRDesignElement element) {
        element.setElementGroup(null);
        int idx = this.children.indexOf(element);
        if (idx >= 0) {
            this.children.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_CHILDREN, element, idx);
        }
        return element;
    }

    public void addElementGroup(JRDesignElementGroup elemGrp) {
        this.addElementGroup(this.children.size(), elemGrp);
    }

    public void addElementGroup(int index, JRDesignElementGroup elemGrp) {
        elemGrp.setElementGroup(this);
        this.children.add(index, elemGrp);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_CHILDREN, elemGrp, index);
    }

    public JRDesignElementGroup removeElementGroup(JRDesignElementGroup elemGrp) {
        elemGrp.setElementGroup(null);
        int idx = this.children.indexOf(elemGrp);
        if (idx >= 0) {
            this.children.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_CHILDREN, elemGrp, idx);
        }
        return elemGrp;
    }

    @Override
    public Object clone() {
        JRDesignElementGroup clone = (JRDesignElementGroup)super.clone();
        clone.eventSupport = null;
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JRPropertyChangeSupport getEventSupport() {
        JRDesignElementGroup jRDesignElementGroup = this;
        synchronized (jRDesignElementGroup) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }
}

