/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.data;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.StringTokenizer;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.data.JRAbstractTextDataSource;
import net.sf.jasperreports.engine.util.JsonUtil;
import net.sf.jasperreports.repo.RepositoryUtil;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;

public class JsonDataSource
extends JRAbstractTextDataSource
implements JRRewindableDataSource {
    private String selectExpression;
    private Iterator<JsonNode> jsonNodesIterator;
    private JsonNode currentJsonNode;
    private final String PROPERTY_SEPARATOR = ".";
    private final String ARRAY_LEFT = "[";
    private final String ARRAY_RIGHT = "]";
    private final String ATTRIBUTE_LEFT = "(";
    private final String ATTRIBUTE_RIGHT = ")";
    private JsonNode jsonTree;
    private ObjectMapper mapper;
    private InputStream jsonStream;
    private boolean toClose;

    public JsonDataSource(InputStream stream) throws JRException {
        this(stream, null);
    }

    public JsonDataSource(InputStream jsonStream, String selectExpression) throws JRException {
        try {
            this.jsonStream = jsonStream;
            this.mapper = new ObjectMapper();
            this.mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
            this.mapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
            this.mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
            this.jsonTree = this.mapper.readTree(jsonStream);
            this.selectExpression = selectExpression;
            this.moveFirst();
        }
        catch (JsonProcessingException e) {
            throw new JRException(e);
        }
        catch (IOException e) {
            throw new JRException(e);
        }
    }

    public JsonDataSource(File file) throws FileNotFoundException, JRException {
        this(file, null);
    }

    public JsonDataSource(File file, String selectExpression) throws FileNotFoundException, JRException {
        this(new FileInputStream(file), selectExpression);
        this.toClose = true;
    }

    public JsonDataSource(JasperReportsContext jasperReportsContext, String location, String selectExpression) throws JRException {
        this(RepositoryUtil.getInstance(jasperReportsContext).getInputStreamFromLocation(location), selectExpression);
        this.toClose = true;
    }

    public JsonDataSource(String location, String selectExpression) throws JRException {
        this(DefaultJasperReportsContext.getInstance(), location, selectExpression);
    }

    @Override
    public void moveFirst() throws JRException {
        if (this.jsonTree == null || this.jsonTree.isMissingNode()) {
            throw new JRException("No JSON data to operate on!");
        }
        this.currentJsonNode = null;
        JsonNode result = this.getJsonData(this.jsonTree, this.selectExpression);
        if (result != null && result.isObject()) {
            final ArrayList<JsonNode> list = new ArrayList<JsonNode>();
            list.add(result);
            this.jsonNodesIterator = new Iterator<JsonNode>(){
                private int count = -1;

                @Override
                public void remove() {
                    list.remove(this.count);
                }

                @Override
                public JsonNode next() {
                    ++this.count;
                    return (JsonNode)list.get(this.count);
                }

                @Override
                public boolean hasNext() {
                    return this.count < list.size() - 1;
                }
            };
        } else if (result != null && result.isArray()) {
            this.jsonNodesIterator = result.getElements();
        }
    }

    @Override
    public boolean next() {
        if (this.jsonNodesIterator == null || !this.jsonNodesIterator.hasNext()) {
            return false;
        }
        this.currentJsonNode = this.jsonNodesIterator.next();
        return true;
    }

    @Override
    public Object getFieldValue(JRField jrField) throws JRException {
        if (this.currentJsonNode == null) {
            return null;
        }
        String expression = jrField.getDescription();
        if (expression == null || expression.length() == 0) {
            return null;
        }
        Object value = null;
        Class<?> valueClass = jrField.getValueClass();
        JsonNode selectedObject = this.getJsonData(this.currentJsonNode, expression);
        if (Object.class != valueClass) {
            if (selectedObject != null) {
                try {
                    if (valueClass.equals(String.class)) {
                        value = selectedObject.asText();
                    }
                    if (valueClass.equals(Boolean.class)) {
                        value = selectedObject.getBooleanValue();
                    }
                    if (Number.class.isAssignableFrom(valueClass)) {
                        value = this.convertStringValue(selectedObject.asText(), valueClass);
                    }
                    if (Date.class.isAssignableFrom(valueClass)) {
                        value = this.convertStringValue(selectedObject.asText(), valueClass);
                    }
                    throw new JRException("Field '" + jrField.getName() + "' is of class '" + valueClass.getName() + "' and cannot be converted");
                }
                catch (Exception e) {
                    throw new JRException("Unable to get value for field '" + jrField.getName() + "' of class '" + valueClass.getName() + "'", e);
                }
            }
        } else {
            value = selectedObject;
        }
        return value;
    }

    protected JsonNode getJsonData(JsonNode rootNode, String jsonExpression) throws JRException {
        if (jsonExpression == null || jsonExpression.length() == 0) {
            return rootNode;
        }
        JsonNode tempNode = rootNode;
        StringTokenizer tokenizer = new StringTokenizer(jsonExpression, ".");
        while (tokenizer.hasMoreTokens()) {
            String currentToken = tokenizer.nextToken();
            int currentTokenLength = currentToken.length();
            int indexOfLeftSquareBracket = currentToken.indexOf("[");
            if (indexOfLeftSquareBracket != -1) {
                if (currentToken.lastIndexOf("]") != currentTokenLength - 1) {
                    throw new JRException("Invalid expression: " + jsonExpression + "; current token " + currentToken + " not ended properly");
                }
                if (indexOfLeftSquareBracket > 0) {
                    String property = currentToken.substring(0, indexOfLeftSquareBracket);
                    tempNode = this.goDownPathWithAttribute(tempNode, property);
                    String arrayOperators = currentToken.substring(indexOfLeftSquareBracket);
                    StringTokenizer arrayOpsTokenizer = new StringTokenizer(arrayOperators, "]");
                    while (arrayOpsTokenizer.hasMoreTokens()) {
                        if (tempNode.isMissingNode() || !tempNode.isArray()) continue;
                        String currentArrayOperator = arrayOpsTokenizer.nextToken();
                        tempNode = tempNode.path(Integer.parseInt(currentArrayOperator.substring(1)));
                    }
                    continue;
                }
                String arrayOperators = currentToken.substring(indexOfLeftSquareBracket);
                StringTokenizer arrayOpsTokenizer = new StringTokenizer(arrayOperators, "]");
                while (arrayOpsTokenizer.hasMoreTokens()) {
                    if (tempNode.isMissingNode() || !tempNode.isArray()) continue;
                    String currentArrayOperator = arrayOpsTokenizer.nextToken();
                    tempNode = tempNode.path(Integer.parseInt(currentArrayOperator.substring(1)));
                }
                continue;
            }
            tempNode = this.goDownPathWithAttribute(tempNode, currentToken);
        }
        return tempNode;
    }

    protected JsonNode goDownPathWithAttribute(JsonNode rootNode, String pathWithAttributeExpression) throws JRException {
        int indexOfLeftRoundBracket = pathWithAttributeExpression.indexOf("(");
        if (indexOfLeftRoundBracket != -1) {
            if (pathWithAttributeExpression.indexOf(")") != pathWithAttributeExpression.length() - 1) {
                throw new JRException("Invalid attribute selection expression: " + pathWithAttributeExpression);
            }
            if (rootNode != null && !rootNode.isMissingNode()) {
                String path = pathWithAttributeExpression.substring(0, indexOfLeftRoundBracket);
                String attributeExpression = pathWithAttributeExpression.substring(indexOfLeftRoundBracket + 1, pathWithAttributeExpression.length() - 1);
                ArrayNode result = null;
                if (rootNode.isObject()) {
                    if (!rootNode.path(path).isMissingNode()) {
                        if (rootNode.path(path).isObject()) {
                            if (this.isValidExpression(rootNode.path(path), attributeExpression)) {
                                result = rootNode.path(path);
                            }
                        } else if (rootNode.path(path).isArray()) {
                            result = this.mapper.createArrayNode();
                            for (JsonNode node : rootNode.path(path)) {
                                if (!this.isValidExpression(node, attributeExpression)) continue;
                                result.add(node);
                            }
                        }
                    }
                } else if (rootNode.isArray()) {
                    result = this.mapper.createArrayNode();
                    for (JsonNode node : rootNode) {
                        JsonNode deeperNode = node.path(path);
                        if (deeperNode.isMissingNode() || !this.isValidExpression(deeperNode, attributeExpression)) continue;
                        result.add(deeperNode);
                    }
                }
                return result;
            }
        } else {
            return this.goDownPath(rootNode, pathWithAttributeExpression);
        }
        return rootNode;
    }

    protected JsonNode goDownPath(JsonNode rootNode, String simplePath) {
        if (rootNode != null && !rootNode.isMissingNode()) {
            JsonNode result = null;
            if (rootNode.isObject()) {
                result = rootNode.path(simplePath);
            } else if (rootNode.isArray()) {
                result = this.mapper.createArrayNode();
                for (JsonNode node : rootNode) {
                    JsonNode deeperNode = node.path(simplePath);
                    if (deeperNode.isMissingNode()) continue;
                    ((ArrayNode)result).add(deeperNode);
                }
            }
            return result;
        }
        return rootNode;
    }

    protected boolean isValidExpression(JsonNode operand, String attributeExpression) throws JRException {
        return JsonUtil.evaluateJsonExpression(operand, attributeExpression);
    }

    public static void main(String[] args) throws Exception {
    }

    public void close() {
        if (this.toClose) {
            try {
                this.jsonStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

