/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.data.mondrian;

import java.sql.Connection;
import java.util.Locale;
import java.util.Map;
import javax.sql.DataSource;
import mondrian.olap.DriverManager;
import mondrian.olap.Util;
import net.sf.jasperreports.data.jdbc.JdbcDataAdapterService;
import net.sf.jasperreports.data.mondrian.MondrianDataAdapter;
import net.sf.jasperreports.data.mondrian.SimpleSQLDataSource;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReportsContext;

public class MondrianDataAdapterService
extends JdbcDataAdapterService {
    private mondrian.olap.Connection connection = null;

    public MondrianDataAdapterService(JasperReportsContext jasperReportsContext, MondrianDataAdapter jdbcDataAdapter) {
        super(jasperReportsContext, jdbcDataAdapter);
    }

    public MondrianDataAdapterService(MondrianDataAdapter jdbcDataAdapter) {
        super((JasperReportsContext)DefaultJasperReportsContext.getInstance(), jdbcDataAdapter);
    }

    @Override
    public MondrianDataAdapter getJdbcDataAdapter() {
        return (MondrianDataAdapter)this.getDataAdapter();
    }

    @Override
    public void contributeParameters(Map<String, Object> parameters) throws JRException {
        super.contributeParameters(parameters);
        MondrianDataAdapter mda = this.getJdbcDataAdapter();
        if (mda != null) {
            Connection c = (Connection)parameters.get("REPORT_CONNECTION");
            parameters.remove("REPORT_CONNECTION");
            Util.PropertyList props = new Util.PropertyList();
            props.put("Catalog", mda.getCatalogURI());
            props.put("Provider", "mondrian");
            props.put("Locale", Locale.getDefault().getLanguage());
            this.connection = DriverManager.getConnection((Util.PropertyList)props, null, (DataSource)new SimpleSQLDataSource(c));
            parameters.put("MONDRIAN_CONNECTION", this.connection);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.connection != null) {
            this.connection.close();
        }
    }
}

