/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.compilers;

import java.io.File;
import java.io.Serializable;
import net.sf.jasperreports.compilers.JavaScriptCompileData;
import net.sf.jasperreports.compilers.JavaScriptEvaluator;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JRAbstractCompiler;
import net.sf.jasperreports.engine.design.JRCompilationSourceCode;
import net.sf.jasperreports.engine.design.JRCompilationUnit;
import net.sf.jasperreports.engine.design.JRSourceCompileTask;
import net.sf.jasperreports.engine.fill.JREvaluator;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.EvaluatorException;

public class JavaScriptCompiler
extends JRAbstractCompiler {
    public JavaScriptCompiler(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext, false);
    }

    public JavaScriptCompiler() {
        this(DefaultJasperReportsContext.getInstance());
    }

    @Override
    protected void checkLanguage(String language) throws JRException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String compileUnits(JRCompilationUnit[] units, String classpath, File tempDirFile) throws JRException {
        Context context = ContextFactory.getGlobal().enterContext();
        try {
            StringBuffer errors = new StringBuffer();
            int errorCount = 0;
            for (int i = 0; i < units.length; ++i) {
                JRCompilationUnit unit = units[i];
                JavaScriptCompileData compileData = new JavaScriptCompileData();
                for (JRExpression expr : unit.getExpressions()) {
                    int id = unit.getCompileTask().getExpressionId(expr);
                    JavaScriptCompileData.Expression jsExpr = JavaScriptEvaluator.createJSExpression(expr);
                    try {
                        context.compileString(jsExpr.getDefaultExpression(), "expression", 0, null);
                    }
                    catch (EvaluatorException e) {
                        this.appendError(errors, ++errorCount, e);
                    }
                    compileData.addExpression(id, jsExpr);
                }
                unit.setCompileData(compileData);
            }
            String errorsMessage = null;
            if (errorCount > 0) {
                errorsMessage = errorCount + " error(s):\n" + errors;
            }
            String string = errorsMessage;
            return string;
        }
        finally {
            Context.exit();
        }
    }

    protected void appendError(StringBuffer errors, int errorCount, EvaluatorException e) {
        errors.append(errorCount);
        errors.append(". ");
        String message = e.getMessage();
        errors.append(message);
        errors.append(" at column ");
        errors.append(e.columnNumber());
        String lineSource = e.lineSource();
        if (lineSource != null) {
            errors.append(" in line\n");
            errors.append(lineSource);
        }
        errors.append("\n");
    }

    @Override
    protected JRCompilationSourceCode generateSourceCode(JRSourceCompileTask sourceTask) throws JRException {
        return null;
    }

    @Override
    protected String getSourceFileName(String unitName) {
        return unitName + ".js";
    }

    @Override
    protected JREvaluator loadEvaluator(Serializable compileData, String unitName) throws JRException {
        if (!(compileData instanceof JavaScriptCompileData)) {
            throw new JRException("Invalid compile data, should be an instance of " + JavaScriptCompileData.class.getName());
        }
        JavaScriptCompileData jsCompileData = (JavaScriptCompileData)compileData;
        return new JavaScriptEvaluator(jsCompileData);
    }
}

