/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.spi;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.lucene.document.Field;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.util.Version;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XAnnotatedElement;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XMember;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.annotations.common.util.StringHelper;
import org.hibernate.search.SearchException;
import org.hibernate.search.analyzer.Discriminator;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.annotations.AnalyzerDefs;
import org.hibernate.search.annotations.AnalyzerDiscriminator;
import org.hibernate.search.annotations.Boost;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.ClassBridges;
import org.hibernate.search.annotations.ContainedIn;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.DynamicBoost;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.Latitude;
import org.hibernate.search.annotations.Longitude;
import org.hibernate.search.annotations.Norms;
import org.hibernate.search.annotations.NumericField;
import org.hibernate.search.annotations.NumericFields;
import org.hibernate.search.annotations.Spatial;
import org.hibernate.search.annotations.Spatials;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.annotations.TermVector;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.StringBridge;
import org.hibernate.search.bridge.builtin.impl.DefaultStringBridge;
import org.hibernate.search.bridge.builtin.impl.NullEncodingFieldBridge;
import org.hibernate.search.bridge.impl.BridgeFactory;
import org.hibernate.search.bridge.spi.ConversionContext;
import org.hibernate.search.engine.BoostStrategy;
import org.hibernate.search.engine.impl.AnnotationProcessingHelper;
import org.hibernate.search.engine.impl.DefaultBoostStrategy;
import org.hibernate.search.engine.impl.FieldMetadata;
import org.hibernate.search.engine.impl.LuceneOptionsImpl;
import org.hibernate.search.engine.impl.WorkPlan;
import org.hibernate.search.engine.spi.DepthValidator;
import org.hibernate.search.engine.spi.EntityState;
import org.hibernate.search.impl.ConfigContext;
import org.hibernate.search.spatial.Coordinates;
import org.hibernate.search.spi.InstanceInitializer;
import org.hibernate.search.util.impl.ClassLoaderHelper;
import org.hibernate.search.util.impl.PassThroughAnalyzer;
import org.hibernate.search.util.impl.ReflectionHelper;
import org.hibernate.search.util.impl.ScopedAnalyzer;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public abstract class AbstractDocumentBuilder<T> {
    private static final Log log = LoggerFactory.make();
    private static final StringBridge NULL_EMBEDDED_STRING_BRIDGE = new DefaultStringBridge();
    private static final String EMPTY = "";
    private final XClass beanXClass;
    protected final String beanXClassName;
    protected final Class<?> beanClass;
    protected final InstanceInitializer instanceInitalizer;
    private Set<Class<?>> mappedSubclasses = new HashSet();
    private int level = 0;
    private int maxLevel = Integer.MAX_VALUE;
    private final ScopedAnalyzer analyzer = new ScopedAnalyzer();
    private Similarity similarity;
    private boolean isRoot;
    private final org.apache.lucene.analysis.Analyzer passThroughAnalyzer;
    protected final Set<String> fieldCollectionRoles = new TreeSet<String>();
    protected final Set<String> indexedEmbeddedCollectionRoles = new TreeSet<String>();
    protected final Set<String> containedInCollectionRoles = new TreeSet<String>();
    protected final Set<String> spatialNames = new TreeSet<String>();
    protected final PropertiesMetadata metadata = new PropertiesMetadata();
    protected EntityState entityState;
    protected ReflectionManager reflectionManager;
    private boolean stateInspectionOptimizationsEnabled = true;

    public AbstractDocumentBuilder(XClass xClass, ConfigContext context, Similarity similarity, ReflectionManager reflectionManager, Set<XClass> optimizationBlackList, InstanceInitializer instanceInitializer) {
        if (xClass == null) {
            throw new AssertionFailure("Unable to build a DocumentBuilderContainedEntity with a null class");
        }
        Version luceneVersion = context.getLuceneMatchVersion();
        this.passThroughAnalyzer = new PassThroughAnalyzer(luceneVersion);
        this.instanceInitalizer = instanceInitializer;
        this.entityState = EntityState.CONTAINED_IN_ONLY;
        this.beanXClass = xClass;
        this.beanXClassName = xClass.getName();
        this.reflectionManager = reflectionManager;
        this.beanClass = reflectionManager.toClass(xClass);
        this.similarity = similarity;
        this.metadata.boost = this.getBoost(xClass);
        this.metadata.classBoostStrategy = this.getDynamicBoost(xClass);
        this.metadata.analyzer = context.getDefaultAnalyzer();
        HashSet<XClass> processedClasses = new HashSet<XClass>();
        processedClasses.add(xClass);
        this.initializeClass(xClass, this.metadata, true, EMPTY, processedClasses, context, optimizationBlackList, false, null);
        this.analyzer.setGlobalAnalyzer(this.metadata.analyzer);
        if (this.similarity == null) {
            this.similarity = context.getDefaultSimilarity();
        }
    }

    public abstract void addWorkToQueue(Class<T> var1, T var2, Serializable var3, boolean var4, boolean var5, List<LuceneWork> var6, ConversionContext var7);

    protected abstract void documentBuilderSpecificChecks(XProperty var1, PropertiesMetadata var2, boolean var3, String var4, ConfigContext var5, PathsContext var6);

    public abstract Serializable getId(Object var1);

    public boolean isRoot() {
        return this.isRoot;
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public XClass getBeanXClass() {
        return this.beanXClass;
    }

    public PropertiesMetadata getMetadata() {
        return this.metadata;
    }

    public Similarity getSimilarity() {
        return this.similarity;
    }

    public ScopedAnalyzer getAnalyzer() {
        return this.analyzer;
    }

    public EntityState getEntityState() {
        return this.entityState;
    }

    public Set<Class<?>> getMappedSubclasses() {
        return this.mappedSubclasses;
    }

    public void postInitialize(Set<Class<?>> indexedClasses) {
        Class<?> plainClass = this.beanClass;
        if (this.entityState == EntityState.NON_INDEXABLE) {
            throw new AssertionFailure("A non indexed entity is post processed");
        }
        HashSet tempMappedSubclasses = new HashSet();
        for (Class<?> currentClass : indexedClasses) {
            if (plainClass == currentClass || !plainClass.isAssignableFrom(currentClass)) continue;
            tempMappedSubclasses.add(currentClass);
        }
        this.mappedSubclasses = Collections.unmodifiableSet(tempMappedSubclasses);
        this.isRoot = true;
        for (Class<?> superClass = plainClass.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            if (!indexedClasses.contains(superClass)) continue;
            this.isRoot = false;
            break;
        }
        this.reflectionManager = null;
    }

    protected void addToScopedAnalyzer(String fieldName, org.apache.lucene.analysis.Analyzer analyzer, Field.Index index) {
        if (Field.Index.ANALYZED.equals((Object)index) || Field.Index.ANALYZED_NO_NORMS.equals((Object)index)) {
            if (analyzer != null) {
                this.analyzer.addScopedAnalyzer(fieldName, analyzer);
            }
        } else {
            this.analyzer.addScopedAnalyzer(fieldName, this.passThroughAnalyzer);
        }
    }

    public void appendContainedInWorkForInstance(Object instance, WorkPlan workplan, DepthValidator currentDepth) {
        for (int i = 0; i < this.metadata.containedInGetters.size(); ++i) {
            XMember member = this.metadata.containedInGetters.get(i);
            Object unproxiedInstance = this.instanceInitalizer.unproxy(instance);
            DepthValidator depth = this.updateDepth(unproxiedInstance, member, currentDepth);
            depth.increaseDepth();
            if (depth.isMaxDepthReached()) {
                return;
            }
            Object value = ReflectionHelper.getMemberValue(unproxiedInstance, member);
            if (value == null) continue;
            if (member.isArray()) {
                Object[] array;
                for (Object arrayValue : array = (Object[])value) {
                    this.processSingleContainedInInstance(workplan, arrayValue, depth);
                }
                continue;
            }
            if (member.isCollection()) {
                Collection<T> collection;
                block8: {
                    collection = null;
                    try {
                        collection = this.getActualCollection(member, value);
                        collection.size();
                    }
                    catch (Exception e) {
                        if (!e.getClass().getName().contains("org.hibernate.LazyInitializationException")) break block8;
                        collection = null;
                    }
                }
                if (collection == null) continue;
                for (T collectionValue : collection) {
                    this.processSingleContainedInInstance(workplan, collectionValue, depth);
                }
                continue;
            }
            this.processSingleContainedInInstance(workplan, value, depth);
        }
    }

    private DepthValidator updateDepth(Object instance, XMember member, DepthValidator currentDepth) {
        Integer maxDepth = null;
        if (instance != null) {
            Map<String, Integer> maxDepths = this.metadata.containedInDepths;
            String key = this.depthKey(instance.getClass(), member.getName());
            maxDepth = maxDepths.get(key);
        }
        if (maxDepth != null) {
            if (currentDepth == null) {
                return new DepthValidator(maxDepth);
            }
            int depth = currentDepth.getDepth();
            if (depth <= maxDepth) {
                return currentDepth;
            }
            return new DepthValidator(maxDepth);
        }
        if (currentDepth != null) {
            return currentDepth;
        }
        return new DepthValidator(Integer.MAX_VALUE);
    }

    private void initializeClass(XClass clazz, PropertiesMetadata propertiesMetadata, boolean isRoot, String prefix, Set<XClass> processedClasses, ConfigContext context, Set<XClass> optimizationBlackList, boolean disableOptimizationsArg, PathsContext pathsContext) {
        LinkedList<XClass> hierarchy = new LinkedList<XClass>();
        XClass previousClass = clazz;
        while (previousClass != null) {
            XClass next = previousClass.getSuperclass();
            if (next != null) {
                hierarchy.add(0, previousClass);
            }
            previousClass = next;
        }
        for (XClass currentClass : hierarchy) {
            this.initializeClassLevelAnnotations(currentClass, propertiesMetadata, isRoot, prefix, context);
        }
        boolean disableOptimizations = disableOptimizationsArg || !this.stateInspectionOptimizationsEnabled();
        for (XClass currentClass : hierarchy) {
            List methods = currentClass.getDeclaredProperties("property");
            for (XProperty method : methods) {
                this.initializeMemberLevelAnnotations(currentClass, method, propertiesMetadata, isRoot, prefix, processedClasses, context, optimizationBlackList, disableOptimizations, pathsContext);
            }
            List fields = currentClass.getDeclaredProperties("field");
            for (XProperty field : fields) {
                this.initializeMemberLevelAnnotations(currentClass, field, propertiesMetadata, isRoot, prefix, processedClasses, context, optimizationBlackList, disableOptimizations, pathsContext);
            }
        }
    }

    private void initializeClassLevelAnnotations(XClass clazz, PropertiesMetadata propertiesMetadata, boolean isRoot, String prefix, ConfigContext context) {
        Spatials spatialsAnn;
        Spatial spatialAnn;
        ClassBridge classBridgeAnn;
        org.apache.lucene.analysis.Analyzer analyzer = AnnotationProcessingHelper.getAnalyzer((Analyzer)clazz.getAnnotation(Analyzer.class), context);
        if (analyzer != null) {
            propertiesMetadata.analyzer = analyzer;
        }
        this.checkForAnalyzerDefs((XAnnotatedElement)clazz, context);
        ClassBridges classBridgesAnn = (ClassBridges)clazz.getAnnotation(ClassBridges.class);
        if (classBridgesAnn != null) {
            ClassBridge[] classBridges;
            for (ClassBridge cb : classBridges = classBridgesAnn.value()) {
                this.bindClassBridgeAnnotation(prefix, propertiesMetadata, cb, clazz, context);
            }
        }
        if ((classBridgeAnn = (ClassBridge)clazz.getAnnotation(ClassBridge.class)) != null) {
            this.bindClassBridgeAnnotation(prefix, propertiesMetadata, classBridgeAnn, clazz, context);
        }
        if ((spatialAnn = (Spatial)clazz.getAnnotation(Spatial.class)) != null) {
            this.bindSpatialAnnotation(prefix, propertiesMetadata, spatialAnn, clazz, context);
        }
        if ((spatialsAnn = (Spatials)clazz.getAnnotation(Spatials.class)) != null) {
            Spatial[] spatials;
            for (Spatial spatial : spatials = spatialsAnn.value()) {
                this.bindSpatialAnnotation(prefix, propertiesMetadata, spatial, clazz, context);
            }
        }
        this.checkForAnalyzerDiscriminator((XAnnotatedElement)clazz, propertiesMetadata, context);
        if (isRoot) {
            this.checkForSimilarity(clazz);
        }
    }

    private void initializeMemberLevelAnnotations(XClass classHostingMember, XProperty member, PropertiesMetadata propertiesMetadata, boolean isRoot, String prefix, Set<XClass> processedClasses, ConfigContext context, Set<XClass> optimizationBlackList, boolean disableOptimizations, PathsContext pathsContext) {
        this.checkForField(classHostingMember, member, propertiesMetadata, prefix, context, pathsContext);
        this.checkForFields(classHostingMember, member, propertiesMetadata, prefix, context, pathsContext);
        this.checkForSpatial(classHostingMember, member, propertiesMetadata, prefix, context, pathsContext);
        this.checkForSpatials(classHostingMember, member, propertiesMetadata, prefix, context, pathsContext);
        this.checkForAnalyzerDefs((XAnnotatedElement)member, context);
        this.checkForAnalyzerDiscriminator((XAnnotatedElement)member, propertiesMetadata, context);
        this.checkForIndexedEmbedded(classHostingMember, member, propertiesMetadata, prefix, processedClasses, context, optimizationBlackList, disableOptimizations, pathsContext);
        this.checkForContainedIn(classHostingMember, member, propertiesMetadata);
        this.documentBuilderSpecificChecks(member, propertiesMetadata, isRoot, prefix, context, pathsContext);
    }

    private void checkForAnalyzerDefs(XAnnotatedElement annotatedElement, ConfigContext context) {
        AnalyzerDefs defs = (AnalyzerDefs)annotatedElement.getAnnotation(AnalyzerDefs.class);
        if (defs != null) {
            for (AnalyzerDef def : defs.value()) {
                context.addAnalyzerDef(def, annotatedElement);
            }
        }
        AnalyzerDef def = (AnalyzerDef)annotatedElement.getAnnotation(AnalyzerDef.class);
        context.addAnalyzerDef(def, annotatedElement);
    }

    private void checkForAnalyzerDiscriminator(XAnnotatedElement annotatedElement, PropertiesMetadata propertiesMetadata, ConfigContext context) {
        AnalyzerDiscriminator discriminatorAnn = (AnalyzerDiscriminator)annotatedElement.getAnnotation(AnalyzerDiscriminator.class);
        if (discriminatorAnn != null) {
            if (propertiesMetadata.discriminator != null) {
                throw new SearchException("Multiple AnalyzerDiscriminator defined in the same class hierarchy: " + this.beanXClass.getName());
            }
            if (annotatedElement instanceof XProperty && this.isPropertyTransient((XProperty)annotatedElement, context)) {
                this.forceStateInspectionOptimizationsDisabled();
            }
            Class<? extends Discriminator> discriminatorClass = discriminatorAnn.impl();
            try {
                propertiesMetadata.discriminator = discriminatorClass.newInstance();
            }
            catch (Exception e) {
                throw new SearchException("Unable to instantiate analyzer discriminator implementation: " + discriminatorClass.getName());
            }
            if (annotatedElement instanceof XMember) {
                propertiesMetadata.discriminatorGetter = (XMember)annotatedElement;
            }
        }
    }

    private void checkForFields(XClass classHostingMember, XProperty member, PropertiesMetadata propertiesMetadata, String prefix, ConfigContext context, PathsContext pathsContext) {
        Fields fieldsAnn = (Fields)member.getAnnotation(Fields.class);
        NumericFields numericAnns = (NumericFields)member.getAnnotation(NumericFields.class);
        if (fieldsAnn != null) {
            for (Field fieldAnn : fieldsAnn.value()) {
                if (!this.isFieldInPath(fieldAnn, member, pathsContext, prefix) && this.level > this.maxLevel) continue;
                this.bindFieldAnnotation(classHostingMember, member, propertiesMetadata, prefix, fieldAnn, this.getNumericExtension(fieldAnn, numericAnns), context);
            }
        }
    }

    private NumericField getNumericExtension(Field fieldAnn, NumericFields numericFields) {
        if (numericFields == null) {
            return null;
        }
        for (NumericField numericField : numericFields.value()) {
            if (!numericField.forField().equals(fieldAnn.name())) continue;
            return numericField;
        }
        return null;
    }

    private void checkForSimilarity(XClass currClass) {
        org.hibernate.search.annotations.Similarity similarityAnn = (org.hibernate.search.annotations.Similarity)currClass.getAnnotation(org.hibernate.search.annotations.Similarity.class);
        if (similarityAnn != null) {
            if (this.similarity != null) {
                throw new SearchException("Multiple similarities defined in the same class hierarchy or on the index settings: " + this.beanXClass.getName());
            }
            Class<?> similarityClass = similarityAnn.impl();
            try {
                this.similarity = (Similarity)similarityClass.newInstance();
            }
            catch (Exception e) {
                log.similarityInstantiationException(similarityClass.getName(), this.beanXClass.getName());
            }
        }
    }

    private void checkForField(XClass classHostingMember, XProperty member, PropertiesMetadata propertiesMetadata, String prefix, ConfigContext context, PathsContext pathsContext) {
        Field fieldAnn = (Field)member.getAnnotation(Field.class);
        NumericField numericFieldAnn = (NumericField)member.getAnnotation(NumericField.class);
        DocumentId idAnn = (DocumentId)member.getAnnotation(DocumentId.class);
        if (fieldAnn != null && (this.isFieldInPath(fieldAnn, member, pathsContext, prefix) || this.level <= this.maxLevel)) {
            this.bindFieldAnnotation(classHostingMember, member, propertiesMetadata, prefix, fieldAnn, numericFieldAnn, context);
        }
        if (fieldAnn == null && idAnn == null && numericFieldAnn != null) {
            throw new SearchException("@NumericField without a @Field on property '" + member.getName() + "'");
        }
    }

    private boolean isPropertyTransient(XProperty member, ConfigContext context) {
        Annotation transientAnnotation;
        if (!context.isJpaPresent()) {
            return false;
        }
        try {
            Class jpaIdClass = ClassLoaderHelper.classForName("javax.persistence.Transient", ConfigContext.class.getClassLoader());
            transientAnnotation = member.getAnnotation(jpaIdClass);
        }
        catch (ClassNotFoundException e) {
            throw new SearchException("Unable to load @Transient.class even though it should be present ?!");
        }
        return transientAnnotation != null;
    }

    private void checkForSpatials(XClass classHostingMember, XProperty member, PropertiesMetadata propertiesMetadata, String prefix, ConfigContext context, PathsContext pathsContext) {
        Spatials spatialsAnn = (Spatials)member.getAnnotation(Spatials.class);
        if (spatialsAnn != null) {
            for (Spatial spatial : spatialsAnn.value()) {
                if (!this.isFieldInPath(spatial, member, pathsContext, prefix) && this.level > this.maxLevel) continue;
                this.bindSpatialAnnotation(classHostingMember, member, propertiesMetadata, prefix, spatial, context);
            }
        }
    }

    private void checkForSpatial(XClass classHostingMember, XProperty member, PropertiesMetadata propertiesMetadata, String prefix, ConfigContext context, PathsContext pathsContext) {
        Spatial spatialAnn = (Spatial)member.getAnnotation(Spatial.class);
        if (spatialAnn != null && (this.isFieldInPath(spatialAnn, member, pathsContext, prefix) || this.level <= this.maxLevel)) {
            this.bindSpatialAnnotation(classHostingMember, member, propertiesMetadata, prefix, spatialAnn, context);
        }
    }

    private boolean isFieldInPath(Annotation fieldAnn, XProperty member, PathsContext pathsContext, String prefix) {
        String path;
        if (pathsContext != null && pathsContext.containsPath(path = prefix + this.fieldName(fieldAnn, member))) {
            pathsContext.markEncounteredPath(path);
            return true;
        }
        return false;
    }

    private String fieldName(Annotation fieldAnn, XProperty member) {
        if (fieldAnn == null) {
            return member.getName();
        }
        String fieldName = AnnotationProcessingHelper.getFieldName(fieldAnn);
        if (fieldName == null || fieldName.isEmpty()) {
            return member.getName();
        }
        return fieldName;
    }

    private void checkForContainedIn(XClass classHostingMember, XProperty member, PropertiesMetadata propertiesMetadata) {
        ContainedIn containedAnn = (ContainedIn)member.getAnnotation(ContainedIn.class);
        if (containedAnn != null) {
            this.updateContainedInMaxDepths(member, propertiesMetadata);
            ReflectionHelper.setAccessible((XMember)member);
            propertiesMetadata.containedInGetters.add((XMember)member);
            this.containedInCollectionRoles.add(StringHelper.qualify((String)classHostingMember.getName(), (String)member.getName()));
        }
    }

    private void updateContainedInMaxDepths(XProperty member, PropertiesMetadata propertiesMetadata) {
        this.updateContainedInMaxDepth((XMember)member, propertiesMetadata, "field");
        this.updateContainedInMaxDepth((XMember)member, propertiesMetadata, "property");
    }

    private String mappedBy(XMember member) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = member.getAnnotations()) {
            String mappedBy = this.mappedBy(annotation);
            if (!StringHelper.isNotEmpty((String)mappedBy)) continue;
            return mappedBy;
        }
        return EMPTY;
    }

    private String mappedBy(Annotation annotation) {
        try {
            Method declaredMethod = annotation.annotationType().getDeclaredMethod("mappedBy", new Class[0]);
            return (String)declaredMethod.invoke((Object)annotation, new Object[0]);
        }
        catch (SecurityException e) {
            return EMPTY;
        }
        catch (NoSuchMethodException e) {
            return EMPTY;
        }
        catch (IllegalArgumentException e) {
            return EMPTY;
        }
        catch (IllegalAccessException e) {
            return EMPTY;
        }
        catch (InvocationTargetException e) {
            return EMPTY;
        }
    }

    private void updateContainedInMaxDepth(XMember memberWithContainedIn, PropertiesMetadata propertiesMetadata, String accessType) {
        XClass memberReturnedType = memberWithContainedIn.getElementClass();
        String mappedBy = this.mappedBy(memberWithContainedIn);
        List returnedTypeProperties = memberReturnedType.getDeclaredProperties(accessType);
        for (XProperty property : returnedTypeProperties) {
            if (!this.isCorrespondingIndexedEmbedded(mappedBy, property)) continue;
            this.updateDepthProperties(memberWithContainedIn, propertiesMetadata, memberReturnedType, property);
            break;
        }
    }

    private boolean isCorrespondingIndexedEmbedded(String mappedBy, XProperty property) {
        if (!property.isAnnotationPresent(IndexedEmbedded.class)) {
            return false;
        }
        if (mappedBy.isEmpty()) {
            return true;
        }
        return mappedBy.equals(property.getName());
    }

    private void updateDepthProperties(XMember memberWithContainedIn, PropertiesMetadata propertiesMetadata, XClass memberReturnedType, XProperty property) {
        int depth = ((IndexedEmbedded)property.getAnnotation(IndexedEmbedded.class)).depth();
        propertiesMetadata.containedInDepths.put(this.depthKey(memberReturnedType, memberWithContainedIn.getName()), depth);
    }

    private String depthKey(XClass clazz, String mappedBy) {
        return this.key(clazz.getName(), mappedBy);
    }

    private String depthKey(Class<?> clazz, String mappedBy) {
        return this.key(clazz.getName(), mappedBy);
    }

    private String key(String className, String mappedBy) {
        return className + "#" + mappedBy;
    }

    private void checkForIndexedEmbedded(XClass classHostingMember, XProperty member, PropertiesMetadata propertiesMetadata, String prefix, Set<XClass> processedClasses, ConfigContext context, Set<XClass> optimizationBlackList, boolean disableOptimizations, PathsContext pathsContext) {
        IndexedEmbedded embeddedAnn = (IndexedEmbedded)member.getAnnotation(IndexedEmbedded.class);
        if (embeddedAnn != null) {
            this.indexedEmbeddedCollectionRoles.add(StringHelper.qualify((String)classHostingMember.getName(), (String)member.getName()));
            int oldMaxLevel = this.maxLevel;
            int potentialLevel = this.depth(embeddedAnn) + this.level;
            if (potentialLevel < 0) {
                potentialLevel = Integer.MAX_VALUE;
            }
            this.maxLevel = potentialLevel > this.maxLevel ? this.maxLevel : potentialLevel;
            ++this.level;
            XClass elementClass = Void.TYPE == embeddedAnn.targetElement() ? member.getElementClass() : this.reflectionManager.toXClass(embeddedAnn.targetElement());
            if (this.maxLevel == Integer.MAX_VALUE && processedClasses.contains(elementClass)) {
                throw new SearchException("Circular reference. Duplicate use of " + elementClass.getName() + " in root entity " + this.beanXClass.getName() + "#" + this.buildEmbeddedPrefix(prefix, embeddedAnn, member));
            }
            String localPrefix = this.buildEmbeddedPrefix(prefix, embeddedAnn, member);
            PathsContext updatedPathsContext = this.updatePaths(localPrefix, pathsContext, embeddedAnn);
            boolean pathsCreatedAtThisLevel = false;
            if (pathsContext == null && updatedPathsContext != null) {
                pathsCreatedAtThisLevel = true;
            }
            if (this.level <= this.maxLevel || this.isInPath(localPrefix, updatedPathsContext, embeddedAnn)) {
                processedClasses.add(elementClass);
                ReflectionHelper.setAccessible((XMember)member);
                propertiesMetadata.embeddedGetters.add((XMember)member);
                propertiesMetadata.embeddedFieldNames.add(member.getName());
                PropertiesMetadata metadata = new PropertiesMetadata();
                propertiesMetadata.embeddedPropertiesMetadata.add(metadata);
                metadata.boost = AnnotationProcessingHelper.getBoost(member, null).floatValue();
                org.apache.lucene.analysis.Analyzer analyzer = AnnotationProcessingHelper.getAnalyzer((Analyzer)member.getAnnotation(Analyzer.class), context);
                org.apache.lucene.analysis.Analyzer analyzer2 = metadata.analyzer = analyzer != null ? analyzer : propertiesMetadata.analyzer;
                if (disableOptimizations) {
                    optimizationBlackList.add(elementClass);
                }
                this.initializeClass(elementClass, metadata, false, localPrefix, processedClasses, context, optimizationBlackList, disableOptimizations, updatedPathsContext);
                if (member.isArray()) {
                    propertiesMetadata.embeddedContainers.add(PropertiesMetadata.Container.ARRAY);
                } else if (member.isCollection()) {
                    if (Map.class.equals((Object)member.getCollectionClass())) {
                        propertiesMetadata.embeddedContainers.add(PropertiesMetadata.Container.MAP);
                    } else {
                        propertiesMetadata.embeddedContainers.add(PropertiesMetadata.Container.COLLECTION);
                    }
                } else {
                    propertiesMetadata.embeddedContainers.add(PropertiesMetadata.Container.OBJECT);
                }
                String indexNullAs = this.embeddedNullToken(context, embeddedAnn);
                PropertiesMetadata.Container container = propertiesMetadata.embeddedContainers.get(propertiesMetadata.embeddedContainers.size() - 1);
                propertiesMetadata.embeddedNullTokens.add(indexNullAs);
                propertiesMetadata.embeddedNullFields.add(this.embeddedNullField(localPrefix));
                propertiesMetadata.embeddedNullFieldBridges.add(this.guessNullEmbeddedBridge(member, container, indexNullAs));
                processedClasses.remove(elementClass);
            } else if (log.isTraceEnabled()) {
                log.tracef("depth reached, ignoring %s", localPrefix);
            }
            --this.level;
            this.maxLevel = oldMaxLevel;
            if (pathsCreatedAtThisLevel) {
                this.validateAllPathsEncountered(classHostingMember, member, updatedPathsContext);
            }
        }
    }

    private void validateAllPathsEncountered(XClass classHostingMember, XProperty member, PathsContext updatedPathsContext) {
        Set<String> unencounteredPaths = updatedPathsContext.getUnencounteredPaths();
        if (unencounteredPaths.size() > 0) {
            StringBuilder sb = new StringBuilder("Found invalid @IndexedEmbedded->paths configured on class ");
            sb.append(classHostingMember.getName());
            sb.append(", member ");
            sb.append(member.getName());
            sb.append(": ");
            String prefix = updatedPathsContext.embeddedAnn.prefix();
            for (String path : unencounteredPaths) {
                sb.append(this.removeLeadingPrefixFromPath(path, prefix));
                sb.append(',');
            }
            String message = sb.substring(0, sb.length() - 1);
            throw new SearchException(message);
        }
    }

    private String removeLeadingPrefixFromPath(String path, String prefix) {
        if (path.startsWith(prefix)) {
            return path.substring(prefix.length());
        }
        return path;
    }

    private int depth(IndexedEmbedded embeddedAnn) {
        if (this.isDepthNotSet(embeddedAnn) && embeddedAnn.includePaths().length > 0) {
            return 0;
        }
        return embeddedAnn.depth();
    }

    private boolean isDepthNotSet(IndexedEmbedded embeddedAnn) {
        return Integer.MAX_VALUE == embeddedAnn.depth();
    }

    private PathsContext updatePaths(String localPrefix, PathsContext pathsContext, IndexedEmbedded embeddedAnn) {
        if (pathsContext != null) {
            return pathsContext;
        }
        PathsContext newPathsContext = new PathsContext(embeddedAnn);
        for (String path : embeddedAnn.includePaths()) {
            newPathsContext.addPath(localPrefix + path);
        }
        return newPathsContext;
    }

    private boolean isInPath(String localPrefix, PathsContext pathsContext, IndexedEmbedded embeddedAnn) {
        if (pathsContext != null) {
            boolean defaultPrefix = this.isDefaultPrefix(embeddedAnn);
            Iterator i$ = pathsContext.pathsEncounteredState.keySet().iterator();
            while (i$.hasNext()) {
                String path;
                String app = path = (String)i$.next();
                if (defaultPrefix) {
                    app = app + ".";
                }
                if (!app.startsWith(localPrefix)) continue;
                return true;
            }
        }
        return false;
    }

    private FieldBridge guessNullEmbeddedBridge(XProperty member, PropertiesMetadata.Container container, String indexNullAs) {
        if (indexNullAs == null) {
            return null;
        }
        if (PropertiesMetadata.Container.OBJECT == container) {
            return new NullEncodingFieldBridge(NULL_EMBEDDED_STRING_BRIDGE, indexNullAs);
        }
        NumericField numericField = (NumericField)member.getAnnotation(NumericField.class);
        FieldBridge fieldBridge = BridgeFactory.guessType(null, numericField, (XMember)member, this.reflectionManager);
        if (fieldBridge instanceof StringBridge) {
            fieldBridge = new NullEncodingFieldBridge((StringBridge)((Object)fieldBridge), indexNullAs);
        }
        return fieldBridge;
    }

    private void bindClassBridgeAnnotation(String prefix, PropertiesMetadata propertiesMetadata, ClassBridge ann, XClass clazz, ConfigContext context) {
        String fieldName = prefix + ann.name();
        propertiesMetadata.classNames.add(fieldName);
        propertiesMetadata.classStores.add(ann.store());
        Field.Index index = AnnotationProcessingHelper.getIndex(ann.index(), ann.analyze(), ann.norms());
        propertiesMetadata.classIndexes.add(index);
        propertiesMetadata.classTermVectors.add(AnnotationProcessingHelper.getTermVector(ann.termVector()));
        propertiesMetadata.classBridges.add(BridgeFactory.extractType(ann, clazz));
        propertiesMetadata.classBoosts.add(Float.valueOf(ann.boost().value()));
        org.apache.lucene.analysis.Analyzer analyzer = AnnotationProcessingHelper.getAnalyzer(ann.analyzer(), context);
        if (analyzer == null) {
            analyzer = propertiesMetadata.analyzer;
        }
        if (analyzer == null) {
            throw new AssertionFailure("Analyzer should not be undefined");
        }
        this.addToScopedAnalyzer(fieldName, analyzer, index);
    }

    private void bindSpatialAnnotation(String prefix, PropertiesMetadata propertiesMetadata, Spatial ann, XClass clazz, ConfigContext context) {
        String fieldName = !ann.name().isEmpty() ? prefix + ann.name() : clazz.getName();
        if (this.spatialNames.contains(ann.name())) {
            throw log.cannotHaveTwoSpatialsWithDefaultOrSameName(clazz.getName());
        }
        this.spatialNames.add(ann.name());
        propertiesMetadata.classNames.add(fieldName);
        propertiesMetadata.classStores.add(ann.store());
        Field.Index index = AnnotationProcessingHelper.getIndex(Index.YES, Analyze.NO, Norms.NO);
        propertiesMetadata.classIndexes.add(index);
        propertiesMetadata.classTermVectors.add(AnnotationProcessingHelper.getTermVector(TermVector.NO));
        FieldBridge spatialBridge = null;
        if (this.reflectionManager.toXClass(Coordinates.class).isAssignableFrom(clazz)) {
            spatialBridge = BridgeFactory.buildSpatialBridge(ann, clazz, null, null);
        } else {
            List propertyList = clazz.getDeclaredProperties("field");
            String latitudeField = null;
            String longitudeField = null;
            for (XProperty property : propertyList) {
                if (property.isAnnotationPresent(Latitude.class) && ((Latitude)property.getAnnotation(Latitude.class)).of().equals(ann.name())) {
                    if (latitudeField != null) {
                        throw log.ambiguousLatitudeDefinition(this.beanXClassName, latitudeField, property.getName());
                    }
                    latitudeField = property.getName();
                }
                if (!property.isAnnotationPresent(Longitude.class) || !((Longitude)property.getAnnotation(Longitude.class)).of().equals(ann.name())) continue;
                if (longitudeField != null) {
                    throw log.ambiguousLongitudeDefinition(this.beanXClassName, longitudeField, property.getName());
                }
                longitudeField = property.getName();
            }
            if (latitudeField != null && longitudeField != null) {
                spatialBridge = BridgeFactory.buildSpatialBridge(ann, clazz, latitudeField, longitudeField);
            }
        }
        if (spatialBridge == null) {
            throw log.cannotFindCoordinatesNorLatLongForSpatial(ann.name().isEmpty() ? "default" : ann.name(), clazz.getName());
        }
        propertiesMetadata.classBridges.add(spatialBridge);
        propertiesMetadata.classBoosts.add(Float.valueOf(ann.boost().value()));
        org.apache.lucene.analysis.Analyzer analyzer = propertiesMetadata.analyzer;
        if (analyzer == null) {
            throw new AssertionFailure("Analyzer should not be undefined");
        }
    }

    private void bindFieldAnnotation(XClass classHostingMember, XProperty member, PropertiesMetadata propertiesMetadata, String prefix, Field fieldAnnotation, NumericField numericFieldAnnotation, ConfigContext context) {
        if (this.isPropertyTransient(member, context)) {
            this.forceStateInspectionOptimizationsDisabled();
        }
        FieldMetadata fieldMetadata = new FieldMetadata(prefix, member, fieldAnnotation, numericFieldAnnotation, null, context, this.reflectionManager);
        fieldMetadata.appendToPropertiesMetadata(propertiesMetadata);
        this.addToScopedAnalyzer(fieldMetadata.getFieldName(), fieldMetadata.getAnalyzer(), fieldMetadata.getIndex());
        if (member.isCollection()) {
            this.fieldCollectionRoles.add(StringHelper.qualify((String)classHostingMember.getName(), (String)member.getName()));
        }
    }

    private void bindSpatialAnnotation(XClass classHostingMember, XProperty member, PropertiesMetadata propertiesMetadata, String prefix, Spatial spatialAnnotation, ConfigContext context) {
        if (this.spatialNames.contains(spatialAnnotation.name())) {
            throw log.cannotHaveTwoSpatialsWithDefaultOrSameName(classHostingMember.getName());
        }
        this.spatialNames.add(spatialAnnotation.name());
        FieldMetadata fieldMetadata = new FieldMetadata(prefix, member, null, null, spatialAnnotation, context, this.reflectionManager);
        fieldMetadata.appendToPropertiesMetadata(propertiesMetadata);
        if (member.isCollection()) {
            this.fieldCollectionRoles.add(StringHelper.qualify((String)classHostingMember.getName(), (String)member.getName()));
        }
    }

    protected Integer getPrecisionStep(NumericField numericFieldAnn) {
        return numericFieldAnn == null ? 4 : numericFieldAnn.precisionStep();
    }

    private String buildEmbeddedPrefix(String prefix, IndexedEmbedded embeddedAnn, XProperty member) {
        String localPrefix = prefix;
        localPrefix = this.isDefaultPrefix(embeddedAnn) ? localPrefix + member.getName() + '.' : localPrefix + embeddedAnn.prefix();
        return localPrefix;
    }

    private boolean isDefaultPrefix(IndexedEmbedded embeddedAnn) {
        return ".".equals(embeddedAnn.prefix());
    }

    private String embeddedNullField(String localPrefix) {
        if (localPrefix.endsWith(".")) {
            return localPrefix.substring(0, localPrefix.length() - 1);
        }
        return localPrefix;
    }

    private String embeddedNullToken(ConfigContext context, IndexedEmbedded embeddedAnn) {
        String indexNullAs = embeddedAnn.indexNullAs();
        if ("__DO_NOT_INDEX_NULL__".equals(indexNullAs)) {
            return null;
        }
        if ("__DEFAULT_NULL_TOKEN__".equals(indexNullAs)) {
            return context.getDefaultNullToken();
        }
        return indexNullAs;
    }

    private float getBoost(XClass element) {
        float boost = 1.0f;
        if (element == null) {
            return boost;
        }
        Boost boostAnnotation = (Boost)element.getAnnotation(Boost.class);
        if (boostAnnotation != null) {
            boost = boostAnnotation.value();
        }
        return boost;
    }

    private BoostStrategy getDynamicBoost(XClass element) {
        BoostStrategy strategy;
        if (element == null) {
            return null;
        }
        DynamicBoost boostAnnotation = (DynamicBoost)element.getAnnotation(DynamicBoost.class);
        if (boostAnnotation == null) {
            return DefaultBoostStrategy.INSTANCE;
        }
        Class<? extends BoostStrategy> boostStrategyClass = boostAnnotation.impl();
        try {
            strategy = boostStrategyClass.newInstance();
        }
        catch (Exception e) {
            throw new SearchException("Unable to instantiate boost strategy implementation: " + boostStrategyClass.getName());
        }
        return strategy;
    }

    private <T> Collection<T> getActualCollection(XMember member, Object value) {
        Collection collection = Map.class.equals((Object)member.getCollectionClass()) ? ((Map)value).values() : (Collection)value;
        return collection;
    }

    private <T> void processSingleContainedInInstance(WorkPlan workplan, T value, DepthValidator depth) {
        workplan.recurseContainedIn(value, depth);
    }

    public boolean isDirty(String[] dirtyPropertyNames) {
        if (dirtyPropertyNames == null || dirtyPropertyNames.length == 0) {
            return true;
        }
        if (!this.stateInspectionOptimizationsEnabled()) {
            return true;
        }
        for (String dirtyPropertyName : dirtyPropertyNames) {
            Integer propertyIndexInteger = this.metadata.fieldNameToPositionMap.get(dirtyPropertyName);
            if (propertyIndexInteger != null) {
                int propertyIndex = propertyIndexInteger - 1;
                if (this.metadata.fieldIndex.get(propertyIndex).isIndexed()) {
                    return true;
                }
                Store store = this.metadata.fieldStore.get(propertyIndex);
                if (store.equals((Object)Store.YES) || store.equals((Object)Store.COMPRESS)) {
                    return true;
                }
            }
            for (XMember embeddedMember : this.metadata.embeddedGetters) {
                String name = embeddedMember.getName();
                if (!name.equals(dirtyPropertyName)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean requiresProvidedId() {
        return false;
    }

    public boolean isIdMatchingJpaId() {
        return true;
    }

    public boolean isCollectionRoleExcluded(String collectionRole) {
        if (collectionRole == null) {
            return false;
        }
        if (this.stateInspectionOptimizationsEnabled) {
            return !this.fieldCollectionRoles.contains(collectionRole) && !this.indexedEmbeddedCollectionRoles.contains(collectionRole) && !this.containedInCollectionRoles.contains(collectionRole);
        }
        return false;
    }

    boolean stateInspectionOptimizationsEnabled() {
        if (!this.stateInspectionOptimizationsEnabled) {
            return false;
        }
        if (this.metadata.classBridges.size() > 0) {
            log.tracef("State inspection optimization disabled as ClassBridges are enabled on entity %s", this.beanXClassName);
            return false;
        }
        if (!(this.metadata.classBoostStrategy instanceof DefaultBoostStrategy)) {
            log.tracef("State inspection optimization disabled as DynamicBoost is enabled on entity %s", this.beanXClassName);
            return false;
        }
        return true;
    }

    public void forceStateInspectionOptimizationsDisabled() {
        this.stateInspectionOptimizationsEnabled = false;
    }

    public void close() {
        this.analyzer.close();
    }

    public static class PropertiesMetadata {
        public float boost;
        public org.apache.lucene.analysis.Analyzer analyzer;
        public Discriminator discriminator;
        public XMember discriminatorGetter;
        public BoostStrategy classBoostStrategy;
        public final Map<String, Integer> fieldNameToPositionMap = new HashMap<String, Integer>();
        public final List<String> fieldNames = new ArrayList<String>();
        public final List<XMember> fieldGetters = new ArrayList<XMember>();
        public final List<String> fieldGetterNames = new ArrayList<String>();
        public final List<FieldBridge> fieldBridges = new ArrayList<FieldBridge>();
        public final List<Store> fieldStore = new ArrayList<Store>();
        public final List<Field.Index> fieldIndex = new ArrayList<Field.Index>();
        public final List<Float> fieldBoosts = new ArrayList<Float>();
        public final List<BoostStrategy> dynamicFieldBoosts = new ArrayList<BoostStrategy>();
        public final List<Integer> precisionSteps = new ArrayList<Integer>();
        public final List<String> fieldNullTokens = new LinkedList<String>();
        public final List<Field.TermVector> fieldTermVectors = new ArrayList<Field.TermVector>();
        public final List<XMember> embeddedGetters = new ArrayList<XMember>();
        public final List<String> embeddedFieldNames = new ArrayList<String>();
        public final List<String> embeddedNullTokens = new ArrayList<String>();
        public final List<String> embeddedNullFields = new ArrayList<String>();
        public final List<FieldBridge> embeddedNullFieldBridges = new ArrayList<FieldBridge>();
        public final List<PropertiesMetadata> embeddedPropertiesMetadata = new ArrayList<PropertiesMetadata>();
        public final List<Container> embeddedContainers = new ArrayList<Container>();
        public final List<XMember> containedInGetters = new ArrayList<XMember>();
        public final Map<String, Integer> containedInDepths = new HashMap<String, Integer>();
        public final List<String> classNames = new ArrayList<String>();
        public final List<Store> classStores = new ArrayList<Store>();
        public final List<Field.Index> classIndexes = new ArrayList<Field.Index>();
        public final List<FieldBridge> classBridges = new ArrayList<FieldBridge>();
        public final List<Field.TermVector> classTermVectors = new ArrayList<Field.TermVector>();
        public final List<Float> classBoosts = new ArrayList<Float>();

        protected LuceneOptions getClassLuceneOptions(int i) {
            return new LuceneOptionsImpl(this.classStores.get(i), this.classIndexes.get(i), this.classTermVectors.get(i), this.classBoosts.get(i).floatValue());
        }

        protected LuceneOptions getFieldLuceneOptions(int i, Object value) {
            LuceneOptionsImpl options = new LuceneOptionsImpl(this.fieldStore.get(i), this.fieldIndex.get(i), this.fieldTermVectors.get(i), this.fieldBoosts.get(i).floatValue() * this.dynamicFieldBoosts.get(i).defineBoost(value), this.fieldNullTokens.get(i), this.precisionSteps.get(i));
            return options;
        }

        protected float getClassBoost(Object value) {
            return this.boost * this.classBoostStrategy.defineBoost(value);
        }

        public static enum Container {
            OBJECT,
            COLLECTION,
            MAP,
            ARRAY;

        }
    }

    static class PathsContext {
        private final IndexedEmbedded embeddedAnn;
        private final Map<String, Boolean> pathsEncounteredState = new HashMap<String, Boolean>();

        public PathsContext(IndexedEmbedded embeddedAnn) {
            this.embeddedAnn = embeddedAnn;
        }

        public boolean containsPath(String path) {
            return this.pathsEncounteredState.keySet().contains(path);
        }

        public void addPath(String path) {
            this.pathsEncounteredState.put(path, Boolean.FALSE);
        }

        public void markEncounteredPath(String path) {
            this.pathsEncounteredState.put(path, Boolean.TRUE);
        }

        public Set<String> getUnencounteredPaths() {
            HashSet<String> unencounteredPaths = new HashSet<String>();
            for (String path : this.pathsEncounteredState.keySet()) {
                if (!this.notEncountered(path)) continue;
                unencounteredPaths.add(path);
            }
            return unencounteredPaths;
        }

        private boolean notEncountered(String path) {
            return this.pathsEncounteredState.get(path) == false;
        }
    }
}

