/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.jgroups;

import org.hibernate.search.backend.impl.jgroups.AbstractMessageSender;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.jgroups.Channel;
import org.jgroups.Message;

final class ChannelMessageSender
extends AbstractMessageSender {
    private static final Log log = LoggerFactory.make();
    private final boolean channelIsManaged;
    private final String clusterName;

    ChannelMessageSender(Channel channel, boolean channelIsManaged, String clusterName) {
        super(channel);
        this.channelIsManaged = channelIsManaged;
        this.clusterName = clusterName;
    }

    @Override
    public void start() {
        if (this.channel != null && this.channelIsManaged) {
            try {
                this.channel.connect(this.clusterName);
            }
            catch (Exception e) {
                throw log.unableConnectingToJGroupsCluster(this.clusterName, e);
            }
        }
    }

    @Override
    public void stop() {
        if (this.channel != null && this.channel.isOpen() && this.channelIsManaged) {
            log.jGroupsDisconnectingAndClosingChannel(this.clusterName);
            this.channel.disconnect();
            this.channel.close();
        }
    }

    @Override
    public void send(Message message) throws Exception {
        this.channel.send(message);
    }
}

