/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import mondrian.olap.Id;
import mondrian.rolap.DelegatingMemberReader;
import mondrian.rolap.MemberCache;
import mondrian.rolap.MemberReader;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.TupleReader;
import mondrian.rolap.sql.MemberChildrenConstraint;
import mondrian.rolap.sql.TupleConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SubstitutingMemberReader
extends DelegatingMemberReader {
    private final TupleReader.MemberBuilder memberBuilder = new SubstitutingMemberBuilder();

    SubstitutingMemberReader(MemberReader memberReader) {
        super(memberReader);
    }

    private List<RolapMember> desubstitute(List<RolapMember> members) {
        ArrayList<RolapMember> list = new ArrayList<RolapMember>(members.size());
        for (RolapMember member : members) {
            list.add(this.desubstitute(member));
        }
        return list;
    }

    private List<RolapMember> substitute(List<RolapMember> members) {
        ArrayList<RolapMember> list = new ArrayList<RolapMember>(members.size());
        for (RolapMember member : members) {
            list.add(this.substitute(member));
        }
        return list;
    }

    @Override
    public RolapMember getLeadMember(RolapMember member, int n) {
        return this.substitute(this.memberReader.getLeadMember(this.desubstitute(member), n));
    }

    @Override
    public List<RolapMember> getMembersInLevel(RolapLevel level, int startOrdinal, int endOrdinal) {
        return this.substitute(this.memberReader.getMembersInLevel(level, startOrdinal, endOrdinal));
    }

    @Override
    public void getMemberRange(RolapLevel level, RolapMember startMember, RolapMember endMember, List<RolapMember> list) {
        this.memberReader.getMemberRange(level, this.desubstitute(startMember), this.desubstitute(endMember), new SubstitutingMemberList(list));
    }

    @Override
    public int compare(RolapMember m1, RolapMember m2, boolean siblingsAreEqual) {
        return this.memberReader.compare(this.desubstitute(m1), this.desubstitute(m2), siblingsAreEqual);
    }

    @Override
    public RolapHierarchy getHierarchy() {
        return this.memberReader.getHierarchy();
    }

    @Override
    public boolean setCache(MemberCache cache) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<RolapMember> getMembers() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<RolapMember> getRootMembers() {
        return this.substitute(this.memberReader.getRootMembers());
    }

    @Override
    public void getMemberChildren(RolapMember parentMember, List<RolapMember> children) {
        this.memberReader.getMemberChildren(this.desubstitute(parentMember), (List<RolapMember>)new SubstitutingMemberList(children));
    }

    @Override
    public void getMemberChildren(List<RolapMember> parentMembers, List<RolapMember> children) {
        this.memberReader.getMemberChildren(this.desubstitute(parentMembers), (List<RolapMember>)new SubstitutingMemberList(children));
    }

    @Override
    public int getMemberCount() {
        return this.memberReader.getMemberCount();
    }

    @Override
    public RolapMember lookupMember(List<Id.Segment> uniqueNameParts, boolean failIfNotFound) {
        return this.substitute(this.memberReader.lookupMember(uniqueNameParts, failIfNotFound));
    }

    @Override
    public void getMemberChildren(RolapMember member, List<RolapMember> children, MemberChildrenConstraint constraint) {
        this.memberReader.getMemberChildren(this.desubstitute(member), (List<RolapMember>)new SubstitutingMemberList(children), constraint);
    }

    @Override
    public void getMemberChildren(List<RolapMember> parentMembers, List<RolapMember> children, MemberChildrenConstraint constraint) {
        this.memberReader.getMemberChildren(this.desubstitute(parentMembers), (List<RolapMember>)new SubstitutingMemberList(children), constraint);
    }

    @Override
    public List<RolapMember> getMembersInLevel(RolapLevel level, int startOrdinal, int endOrdinal, TupleConstraint constraint) {
        return this.substitute(this.memberReader.getMembersInLevel(level, startOrdinal, endOrdinal, constraint));
    }

    @Override
    public RolapMember getDefaultMember() {
        return this.substitute(this.memberReader.getDefaultMember());
    }

    @Override
    public RolapMember getMemberParent(RolapMember member) {
        return this.substitute(this.memberReader.getMemberParent(this.desubstitute(member)));
    }

    @Override
    public TupleReader.MemberBuilder getMemberBuilder() {
        return this.memberBuilder;
    }

    private class SubstitutingMemberBuilder
    implements TupleReader.MemberBuilder {
        private SubstitutingMemberBuilder() {
        }

        public MemberCache getMemberCache() {
            return SubstitutingMemberReader.this.memberReader.getMemberBuilder().getMemberCache();
        }

        public Object getMemberCacheLock() {
            return SubstitutingMemberReader.this.memberReader.getMemberBuilder().getMemberCacheLock();
        }

        public RolapMember makeMember(RolapMember parentMember, RolapLevel childLevel, Object value, Object captionValue, boolean parentChild, ResultSet resultSet, Object key, int column) throws SQLException {
            return SubstitutingMemberReader.this.substitute(SubstitutingMemberReader.this.memberReader.getMemberBuilder().makeMember(SubstitutingMemberReader.this.desubstitute(parentMember), childLevel, value, captionValue, parentChild, resultSet, key, column));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SubstitutingMemberList
    extends AbstractList<RolapMember> {
        private final List<RolapMember> list;

        SubstitutingMemberList(List<RolapMember> list) {
            this.list = list;
        }

        @Override
        public RolapMember get(int index) {
            return SubstitutingMemberReader.this.desubstitute(this.list.get(index));
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public RolapMember set(int index, RolapMember element) {
            return SubstitutingMemberReader.this.desubstitute(this.list.set(index, SubstitutingMemberReader.this.substitute(element)));
        }

        @Override
        public void add(int index, RolapMember element) {
            this.list.add(index, SubstitutingMemberReader.this.substitute(element));
        }

        @Override
        public RolapMember remove(int index) {
            return this.list.remove(index);
        }
    }
}

