﻿using System;
using System.Text;
using System.Windows.Controls;
using System.Windows.Data;

namespace Progressive.PecaStarter.View.WPF.Page
{
    class YellowPagesPanel : StackPanel
    {
        public YellowPagesPanel(Model.YellowPages yellowPages)
        {
            Tag = yellowPages.Name;
            Visibility = System.Windows.Visibility.Collapsed;
            foreach (var option in yellowPages.Options)
            {
                var created = CreatePanel(option);
                if (created == null)
                {
                    continue;
                }
                Children.Add(created);
            }
        }

        public void UpdateTarget()
        {
            foreach (var stackChild in Children)
            {
                foreach (var dockChild in (stackChild as DockPanel).Children)
                {
                    if (dockChild is CheckBox)
                    {
                        (dockChild as CheckBox).GetBindingExpression(CheckBox.IsCheckedProperty).UpdateTarget();
                        continue;
                    }
                    if (dockChild is ComboBox)
                    {
                        var comboBox = dockChild as ComboBox;
                        if (comboBox.IsEditable)
                        {
                            comboBox.GetBindingExpression(ComboBox.TextProperty).UpdateTarget();
                        }
                        else
                        {
                            comboBox.GetBindingExpression(ComboBox.SelectedValueProperty).UpdateTarget();
                        }
                        continue;
                    }
                    if (dockChild is TextBox)
                    {
                        (dockChild as TextBox).GetBindingExpression(TextBox.TextProperty).UpdateTarget();
                        continue;
                    }
                }
            }
        }

        private DockPanel CreatePanel(Model.YellowPages.Option option)
        {
            if (option is Model.YellowPages.TextOption)
            {
                return CreatePanel(option as Model.YellowPages.TextOption);
            }
            if (option is Model.YellowPages.CheckOption)
            {
                return CreatePanel(option as Model.YellowPages.CheckOption);
            }
            if (option is Model.YellowPages.ComboOption)
            {
                return CreatePanel(option as Model.YellowPages.ComboOption);
            }
            if (option is Model.YellowPages.HiddenOption)
            {
                return null;
            }
            throw new NotImplementedException();
        }

        private DockPanel CreatePanel(Model.YellowPages.TextOption option)
        {
            var dockPanel = new DockPanel();
            dockPanel.Children.Add(CreateLabel(option.Name));
            dockPanel.Children.Add(CreateTextBox(option));
            return dockPanel;
        }

        private DockPanel CreatePanel(Model.YellowPages.CheckOption option)
        {
            var dockPanel = new DockPanel();
            dockPanel.Children.Add(CreateCheckBox(option));
            return dockPanel;
        }

        private DockPanel CreatePanel(Model.YellowPages.ComboOption option)
        {
            var dockPanel = new DockPanel();
            dockPanel.Children.Add(CreateLabel(option.Name));
            dockPanel.Children.Add(CreateComboBox(option));
            return dockPanel;
        }

        private Label CreateLabel(String text)
        {
            return new Label { Content = text + ':' };
        }

        private TextBox CreateTextBox(Model.YellowPages.TextOption option)
        {
            var textBox = new TextBox
            {
                DataContext = option
            };
            textBox.SetBinding(TextBox.TextProperty, new Binding("Value"));
            return textBox;
        }

        private CheckBox CreateCheckBox(Model.YellowPages.CheckOption option)
        {
            var checkBox = new CheckBox
            {
                Content = option.Name,
                DataContext = option
            };
            checkBox.SetBinding(CheckBox.IsCheckedProperty, new Binding("IsChecked"));
            return checkBox;
        }

        private ComboBox CreateComboBox(Model.YellowPages.ComboOption option)
        {
            var comboBox = new ComboBox
            {
                DataContext = option,
                DisplayMemberPath = "Name",
                SelectedValuePath = "Sign",
            };
            foreach (var comboItem in option.ComboItems)
            {
                comboBox.Items.Add(comboItem);
            }
            comboBox.SetBinding(ComboBox.SelectedValueProperty, new Binding("Value"));
            return comboBox;
        }
    }
}
