﻿using System.Windows;
using System.Windows.Controls;
using Progressive.PecaStarter.ViewModel.Broadcast;

namespace Progressive.PecaStarter.View.WPF.Page
{
    /// <summary>
    /// YellowPages.xaml の相互作用ロジック
    /// </summary>
    public partial class YellowPages
    {
        public YellowPages()
        {
        }

        protected void OnLoaded(object sender, RoutedEventArgs e)
        {
            foreach (var yellowPages in (DataContext as YellowPagesViewModel).YellowPageses)
            {
                yellowPagesesPanel.Children.Add(new YellowPagesPanel(yellowPages));
            }
        }

        public void UpdateTarget()
        {
            yellowPagesesComboBox.GetBindingExpression(ComboBox.SelectedIndexProperty).UpdateTarget();
            foreach (var child in yellowPagesesPanel.Children)
            {
                (child as YellowPagesPanel).UpdateTarget();
            }
        }

        private void ChangeVisibility(object sender, RoutedEventArgs e)
        {
            var children = yellowPagesesPanel.Children;
            for (int i = 0, len = children.Count; i < len; i++)
            {
                children[i].Visibility = i == (sender as ComboBox).SelectedIndex ? Visibility.Visible : Visibility.Collapsed;
            }
        }
    }
}
