﻿using System;
using System.Text;
using System.Timers;
using System.Windows.Controls;
using System.Windows.Threading;
using Progressive.PecaStarter.View.WPF.Controls.Behavior;
using Progressive.PecaStarter.ViewModel;

namespace Progressive.PecaStarter.View.WPF.Controls
{
    class CountDownButton : Button
    {
        private abstract class ButtonState
        {
            protected CountDownButton Parent;

            public ButtonState(CountDownButton parent)
            {
                Parent = parent;
            }

            public abstract ButtonState OnClick();
            public abstract void SetContent(string content);
        }
        private class NormalState : ButtonState
        {
            public NormalState(CountDownButton parent) : base(parent) { }

            public override ButtonState OnClick()
            {
                var delay = (Parent.DataContext as BroadcastViewModel).SettingsViewModel.Delay;
                if (delay == 0)
                {
                    if (!Parent.AskBehavior.OnClick())
                    {
                        return this;
                    }
                    Parent.AsyncBehavior.OnClick();
                    Parent.BaseOnClick();
                    return this;
                }
                return new CountDownState(Parent, delay);
            }

            public override void SetContent(string content)
            {
                Parent.Content = content;
            }
        }
        private class CountDownState : ButtonState
        {
            public CountDownState(CountDownButton parent, int delay)
                : base(parent)
            {
                Parent.Count = delay;
                Parent.Timer.Start();
                Parent.Content = Parent.CountDownMessage;
            }

            public override ButtonState OnClick()
            {
                Parent.Timer.Stop();
                Parent.Content = Parent.Text;
                return new NormalState(Parent);
            }

            public override void SetContent(string content) { }
        }

        public string Message { set { AskBehavior.Message = value; } }
        public string Text
        {
            get { return text; }
            set
            {
                text = value;
                State.SetContent(value);
            }
        }
        private AskBehavior AskBehavior;
        private AsyncBehavior AsyncBehavior;
        private string CountDownMessage
        {
            get { return new StringBuilder().Append("...").Append(Count).ToString(); }
        }
        private string text;
        private ButtonState State;
        private DispatcherTimer Timer;
        private int Count;

        public CountDownButton()
        {
            AsyncBehavior = new AsyncBehavior(this);
            AskBehavior = new AskBehavior(this);
            Loaded += AsyncBehavior.OnLoaded;
            State = new NormalState(this);
            Timer = new DispatcherTimer(DispatcherPriority.Normal, Dispatcher);
            Timer.Interval = TimeSpan.FromSeconds(1);
            Timer.Tick += (sender, e) =>
            {
                if (State is CountDownState == false)
                {
                    return;
                }
                Count -= 1;
                if (Count > 0)
                {
                    Content = CountDownMessage;
                    return;
                }
                Content = text;
                Timer.Stop();
                AsyncBehavior.OnClick();
                base.OnClick();
                State = new NormalState(this);
            };
        }

        protected override void OnClick()
        {
            State = State.OnClick();
        }

        private void BaseOnClick()
        {
            base.OnClick();
        }
    }
}
