﻿using System.Windows;
using System.Windows.Controls;
using Progressive.PecaStarter.ViewModel.Command;

namespace Progressive.PecaStarter.View.WPF.Controls.Behavior
{
    class AsyncBehavior : BehaviorBase
    {
        public AsyncBehavior(Button called) : base(called) { }

        public void OnLoaded(object sender, RoutedEventArgs e)
        {
            if (Called.Command == null) return;
            (Called.Command as AsyncCommandBase).Completed += (s1, e1) => Utils.GetRoot(Called).IsEnabled = true;
        }

        public bool OnClick()
        {
            Utils.GetRoot(Called).IsEnabled = false;
            return true;
        }
    }
}
