﻿using System.ComponentModel;
using System.Windows;
using System.Windows.Controls;

namespace Progressive.PecaStarter.View.WPF.Controls
{
    class Alert : ContentControl
    {
        protected override void OnPropertyChanged(DependencyPropertyChangedEventArgs e)
        {
            base.OnPropertyChanged(e);
            if (e.Property.Name != "Content")
            {
                return;
            }
            if (e.NewValue as string == "")
            {
                return;
            }
            MessageBox.Show(Utils.GetRoot(this), e.NewValue as string, "エラー", MessageBoxButton.OK, MessageBoxImage.Error);
        }
    }
}
