﻿using Progressive.PecaStarter.Common;
using Progressive.PecaStarter.Service;
using System.Collections.Generic;
using Progressive.PecaStarter.Model.Peercast;
using System;

namespace Progressive.PecaStarter.ViewModel.Command
{
    class StopCommand : AsyncCommandBase
    {
        public StopCommand(BroadcastViewModel viewModel) : base(viewModel) { }

        public override bool CanExecute(object parameter)
        {
            if (ViewModel.Id == PeercastDefine.NULL_RELAY_ID)
            {
                return false;
            }
            return true;
        }

        protected override object AsyncExecute(object parameter)
        {
            var settings = ViewModel.SettingsViewModel;
            if (settings.Logging)
            {
                new LogAsyncService().Stop(settings.LogPath, settings.ServerAddress, ViewModel.StartAt, ViewModel.ExternalSourceViewModel.Name.Text);
            }
            else
            {
                new LogAsyncService().EndTimer();
            }
            new PeercastService().Stop(ViewModel.SettingsViewModel.ServerAddress, ViewModel.Id);
            StopWebApi();
            return null;
        }

        protected override void AsyncCompleted(object result)
        {
            ViewModel.Id = PeercastDefine.NULL_RELAY_ID;
        }

        private void StopWebApi()
        {
            foreach (var webApi in ViewModel.WebApisViewModel.WebApis)
            {
                if (!webApi.IsAccepted || !webApi.IsEnabled)
                {
                    continue;
                }
                var extSrcVM = ViewModel.ExternalSourceViewModel;
                var list = new List<KeyValuePair<string, string>>();
                Add(list, "name", extSrcVM.Name.Text);
                Add(list, "password", webApi.Options.Find((i) => { return i.Type == "password"; }).Value);
                new WebApi().GetResponse(Array.Find(webApi.Definition.methods, (o) => { return o.type == "stop"; }).url, list);
            }
        }

        private void Add(List<KeyValuePair<string, string>> list, string key, string value)
        {
            list.Add(new KeyValuePair<string, string>(key, value));
        }
    }
}
