﻿using System;
using Progressive.PecaStarter.DTO;
using Progressive.PecaStarter.Service;

namespace Progressive.PecaStarter.ViewModel.Command
{
    public class ImportChannelCommand : CommandBase
    {
        public ImportChannelCommand(BroadcastViewModel viewModel) : base(viewModel) { }
        public event Action Completed;

        #region ICommand メンバ

        override public bool CanExecute(object parameter)
        {
            return ViewModel.RelaySelectDialogViewModel.SelectedChannel != null;
        }

        protected override void OnExecute(object parameter)
        {
            var dto = ViewModel.RelaySelectDialogViewModel.SelectedChannel;
            ViewModel.Id = dto.Id;
            ViewModel.StartAt = DateTime.Now;
            var genre = ViewModel.YellowPagesViewModel.ParseGenre(dto.Genre);
            var externalSource = ViewModel.ExternalSourceViewModel;
            externalSource.Url.Text = "(表示できません)";
            externalSource.Name.Text = dto.Name;
            externalSource.Genre.Text = genre;
            externalSource.Description.Text = dto.Description;
            externalSource.Contact.Text = dto.Url;
            externalSource.Comment.Text = dto.Comment;
            externalSource.Type = dto.Type.ToString();
            var currentTrack = ViewModel.CurrentTrackViewModel;
            currentTrack.Title.Text = dto.TrackTitle;
            currentTrack.Artist.Text = dto.TrackArtist;
            currentTrack.Album.Text = dto.TrackAlbum;
            currentTrack.Genre.Text = dto.TrackGenre;
            currentTrack.Contact.Text = dto.TrackContact;
            if (ViewModel.IsBroadcast)
            {
                new LogAsyncService().EndTimer();
            }
            if (Completed != null) Completed();
        }

        #endregion
    }
}
