﻿using Progressive.PecaStarter.Service;
using Progressive.PecaStarter.Model;
namespace Progressive.PecaStarter.ViewModel.Broadcast
{
    public class SettingsViewModel : ViewModelBase
    {
        public BroadcastViewModel Parent { get; set; }
        public string ServerAddress
        {
            get { return serverAddress; }
            set
            {
                serverAddress = value;
                NotifyPropertyChanged("ServerAddress");
            }
        }
        public bool IsNotifyIcon
        {
            get { return isNotifyIcon; }
            set
            {
                isNotifyIcon = value;
                NotifyPropertyChanged("IsNotifyIcon");
            }
        }
        public bool IsSavePosition
        {
            get { return isSavePosition; }
            set
            {
                isSavePosition = value;
                NotifyPropertyChanged("IsSavePosition");
            }
        }
        public bool Logging
        {
            get { return logging; }
            set
            {
                logging = value;
                NotifyPropertyChanged("Logging");
            }
        }
        public string LogPath
        {
            get { return logPath; }
            set
            {
                logPath = value;
                if (logPath.Length == 0)
                {
                    logPath = new ApplicationModel().DefaultLogFolder;
                }
                NotifyPropertyChanged("LogPath");
            }
        }
        public int Delay
        {
            get { return delay; }
            set
            {
                delay = value;
                NotifyPropertyChanged("Delay");
            }
        }
        private string serverAddress;
        private bool isNotifyIcon;
        private bool isSavePosition;
        private bool logging;
        private string logPath;
        private int delay;

        public SettingsViewModel(BroadcastViewModel parent)
        {
            Parent = parent;
            serverAddress = "";
            isNotifyIcon = false;
            isSavePosition = false;
            logging = false;
            logPath = new ApplicationModel().DefaultLogFolder;
            delay = 0;
        }
    }
}
