﻿using System;

namespace Progressive.PecaStarter.ViewModel.Broadcast
{
    public class ExternalSourceViewModel : ViewModelBase
    {
        public BroadcastViewModel Parent { get; set; }
        public HistoriableTextViewModel Url { get; set; }
        public HistoriableTextViewModel Name { get; set; }
        public HistoriableTextViewModel Genre { get; set; }
        public HistoriableTextViewModel Description { get; set; }
        public HistoriableTextViewModel Contact { get; set; }
        public HistoriableTextViewModel Comment { get; set; }
        public string Type
        {
            get { return type.ToString(); }
            set
            {
                type = (Common.Type)Enum.Parse(typeof(Common.Type), value);
                NotifyPropertyChanged("Type");
            }
        }
        public string[] Types
        {
            get { return Enum.GetNames(typeof(Common.Type)); }
        }
        private Common.Type type;

        public ExternalSourceViewModel(BroadcastViewModel parent)
        {
            Parent = parent;
            Url = new HistoriableTextViewModel(() => NotifyPropertyChanged("Url"));
            Name = new HistoriableTextViewModel(() => NotifyPropertyChanged("Name"));
            Genre = new HistoriableTextViewModel(() => NotifyPropertyChanged("Genre"));
            Description = new HistoriableTextViewModel(() => NotifyPropertyChanged("Description"));
            Contact = new HistoriableTextViewModel(() => NotifyPropertyChanged("Contact"));
            Comment = new HistoriableTextViewModel(() => NotifyPropertyChanged("Comment"));
            type = Common.Type.WMV;
        }
    }
}
