﻿using System;
using System.IO;
using System.Text;
using Progressive.PecaStarter.Entity;

namespace Progressive.PecaStarter.DAO
{
    class LogDAO
    {
        private string Path;

        public LogDAO(string path)
        {
            if (!File.Exists(path))
            {
                Directory.CreateDirectory(path);
            }
            Path = path;
        }

        public void insert(string name, DateTime startAt, Log entity)
        {
            var sb = new StringBuilder();
            sb.Append(entity.DateTime).Append(',');
            sb.Append(entity.Listeners).Append(',');
            sb.Append(entity.Relays).Append(',');
            sb.Append('"').Append(entity.Genre.Replace("\"", "\"\"")).Append('"').Append(',');
            sb.Append('"').Append(entity.Description.Replace("\"", "\"\"")).Append('"').Append(',');
            sb.Append('"').Append(entity.Comment.Replace("\"", "\"\"")).Append('"');
            sb.Append("\r\n");
            File.AppendAllText(Path + System.IO.Path.DirectorySeparatorChar + startAt.ToString("yyyyMMdd_HHmmss-") + name + ".csv"
                , sb.ToString());
        }
    }
}
