package portablesimulator.gui.themes;

import java.awt.Font;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.SwingUtilities;
import portablesimulator.csv.PSConfig;
import portablesimulator.csv.Repository;
import portablesimulator.gui.MyComboBoxElement;
import portablesimulator.gui.MyComboBoxUtil;
import portablesimulator.gui.PSFrame;

public class ThemeManagerDialog extends javax.swing.JDialog {

    PSFrame parentFrame;
    PSConfig config = Repository.getConfig();

    /** Creates new form JLookAndFeelDialog */
    public ThemeManagerDialog(PSFrame parent, boolean modal) {
        super(parent, modal);
        parentFrame = parent;
        initComponents();
        this.setLocationRelativeTo(null);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jButton7 = new javax.swing.JButton();
        jPanel1 = new javax.swing.JPanel();
        jButton1 = new javax.swing.JButton();
        jButton2 = new javax.swing.JButton();
        jButton3 = new javax.swing.JButton();
        jButton8 = new javax.swing.JButton();
        jPanel2 = new javax.swing.JPanel();
        jButton4 = new javax.swing.JButton();
        jButton5 = new javax.swing.JButton();
        jButton6 = new javax.swing.JButton();
        jPanel3 = new javax.swing.JPanel();
        jComboBoxFontName = new javax.swing.JComboBox();
        jComboBoxFontStyle = new javax.swing.JComboBox();
        jComboBoxFontSize = new javax.swing.JComboBox();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        getContentPane().setLayout(new java.awt.GridBagLayout());

        jButton7.setText("OK");
        jButton7.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton7ActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        getContentPane().add(jButton7, gridBagConstraints);

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder("Jte[}"));
        jPanel1.setLayout(new java.awt.GridBagLayout());

        jButton1.setText("v");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        jPanel1.add(jButton1, gridBagConstraints);

        jButton2.setText("ΎR");
        jButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton2ActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        jPanel1.add(jButton2, gridBagConstraints);

        jButton3.setText("");
        jButton3.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton3ActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        jPanel1.add(jButton3, gridBagConstraints);

        jButton8.setText("");
        jButton8.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton8ActionPerformed(evt);
            }
        });
        jPanel1.add(jButton8, new java.awt.GridBagConstraints());

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        getContentPane().add(jPanel1, gridBagConstraints);

        jPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder("VXee[}"));
        jPanel2.setLayout(new java.awt.GridBagLayout());

        jButton4.setText("OSW");
        jButton4.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton4ActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        jPanel2.add(jButton4, gridBagConstraints);

        jButton5.setText("JavaW");
        jButton5.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton5ActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        jPanel2.add(jButton5, gridBagConstraints);

        jButton6.setText("GTKW");
        jButton6.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton6ActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        jPanel2.add(jButton6, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        getContentPane().add(jPanel2, gridBagConstraints);

        jPanel3.setBorder(javax.swing.BorderFactory.createTitledBorder("tHg"));
        jPanel3.setLayout(new java.awt.GridBagLayout());

        jComboBoxFontName.setModel(getFontNameModel());
        jComboBoxFontName.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxFontNameActionPerformed(evt);
            }
        });
        jPanel3.add(jComboBoxFontName, new java.awt.GridBagConstraints());

        jComboBoxFontStyle.setModel(getFontStyleModel());
        jComboBoxFontStyle.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxFontStyleActionPerformed(evt);
            }
        });
        jPanel3.add(jComboBoxFontStyle, new java.awt.GridBagConstraints());

        jComboBoxFontSize.setModel(getFontSizeModel());
        jComboBoxFontSize.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxFontSizeActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        jPanel3.add(jComboBoxFontSize, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        getContentPane().add(jPanel3, gridBagConstraints);

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        config.themeNumber = ThemeManager.THEME_SEA;
        updateLAF();
    }//GEN-LAST:event_jButton1ActionPerformed

    private void jButton2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton2ActionPerformed
        config.themeNumber = ThemeManager.THEME_WINE;
        updateLAF();
    }//GEN-LAST:event_jButton2ActionPerformed

    private void jButton3ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton3ActionPerformed
        config.themeNumber = ThemeManager.THEME_FOREST;
        updateLAF();
    }//GEN-LAST:event_jButton3ActionPerformed

    private void jButton4ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton4ActionPerformed
        config.themeNumber = ThemeManager.THEME_OS_DEFAULT;
        updateLAF();
    }//GEN-LAST:event_jButton4ActionPerformed

    private void jButton5ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton5ActionPerformed
        config.themeNumber = ThemeManager.THEME_JAVA_DEFAULT;
        updateLAF();
    }//GEN-LAST:event_jButton5ActionPerformed

    private void jButton6ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton6ActionPerformed
        config.themeNumber = ThemeManager.THEME_GTK_DEFAULT;
        updateLAF();
    }//GEN-LAST:event_jButton6ActionPerformed

    private void jButton7ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton7ActionPerformed
        setVisible(false);
    }//GEN-LAST:event_jButton7ActionPerformed

    private void jButton8ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton8ActionPerformed
        config.themeNumber = ThemeManager.THEME_STONE;
        updateLAF();
    }//GEN-LAST:event_jButton8ActionPerformed

    private void jComboBoxFontSizeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxFontSizeActionPerformed
        config.fontSize = MyComboBoxUtil.getComboSelectedInt(jComboBoxFontSize, 12);
        updateLAF();
    }//GEN-LAST:event_jComboBoxFontSizeActionPerformed

    private void jComboBoxFontNameActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxFontNameActionPerformed
        config.fontName = (String) MyComboBoxUtil.getComboSelected(jComboBoxFontName).getValue();
        updateLAF();
    }//GEN-LAST:event_jComboBoxFontNameActionPerformed

    private void jComboBoxFontStyleActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxFontStyleActionPerformed
        config.fontStyle = MyComboBoxUtil.getComboSelectedInt(jComboBoxFontStyle, Font.PLAIN);
        updateLAF();
    }//GEN-LAST:event_jComboBoxFontStyleActionPerformed

    public void updateLAF() {
        SwingUtilities.invokeLater(new Runnable() {

            public void run() {
                ThemeManager.setMetalTheme(config.themeNumber);
                ThemeManager.setFont(config.fontName, config.fontStyle, config.fontSize);
                ThemeManager.updateUITree();
                parentFrame.doStyleResultList(true);
                parentFrame.doStyleMysetList(true, "");
            }
        });
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton2;
    private javax.swing.JButton jButton3;
    private javax.swing.JButton jButton4;
    private javax.swing.JButton jButton5;
    private javax.swing.JButton jButton6;
    private javax.swing.JButton jButton7;
    private javax.swing.JButton jButton8;
    private javax.swing.JComboBox jComboBoxFontName;
    private javax.swing.JComboBox jComboBoxFontSize;
    private javax.swing.JComboBox jComboBoxFontStyle;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    // End of variables declaration//GEN-END:variables

    public ComboBoxModel getFontNameModel() {
        DefaultComboBoxModel model = new DefaultComboBoxModel();
        String[] names = {
            "Dialog",
            "Monospaced",
            "DialogInput",
            "Serif",
            "SansSerif",
        };
        String set = Repository.getConfig().fontName;
        for (int i = 0; i < names.length; i++) {
            MyComboBoxElement item = new MyComboBoxElement(names[i], names[i]);
            model.addElement(item);
            if (names[i].equals(set)) {
                model.setSelectedItem(item);
            }
        }
        return model;
    }

    public ComboBoxModel getFontStyleModel() {
        DefaultComboBoxModel model = new DefaultComboBoxModel();
        MyComboBoxElement[] list = {
            new MyComboBoxElement("Plain", Font.PLAIN),
            new MyComboBoxElement("Italic", Font.ITALIC),
            new MyComboBoxElement("Bold", Font.BOLD),
            new MyComboBoxElement("BoldItalic", Font.BOLD + Font.ITALIC),};
        int set = Repository.getConfig().fontStyle;
        for (int i = 0; i < list.length; i++) {
            MyComboBoxElement item = list[i];
            model.addElement(item);
            if (set == item.getValue()) {
                model.setSelectedItem(item);
            }
        }
        return model;
    }

    public ComboBoxModel getFontSizeModel() {
        DefaultComboBoxModel model = new DefaultComboBoxModel();
        int set = Repository.getConfig().fontSize;
        for (int x = 6; x <= 26; x += 1) {
            MyComboBoxElement item = new MyComboBoxElement(String.valueOf(x), x);
            model.addElement(item);
            if (x == set) {
                model.setSelectedItem(item);
            }
        }
        return model;
    }
}
