package portablesimulator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MatrixBuilder implements Iterator {

    List<List> listColumn;
    int[] counter;

    public MatrixBuilder() {
        listColumn = new ArrayList<List>();
    }

    public void addColumn(List column) {
        listColumn.add(column);
        //System.out.println("addColumn@matrixbuilder " + column.size() +" == " + this.iteratorCount() + "---" + column);
    }

    public long iteratorCount() {
        long x = 1;
        for (int i = 0; i < listColumn.size(); ++i) {
            x *= listColumn.get(i).size() == 0 ? 1 : listColumn.get(i).size();
        }
        return x;
    }

    public void start() {
        this.counter = new int[listColumn.size()];
    }

    public boolean hasNext() {
        for (int i = 0; i < counter.length; ++i) {
            if (counter[i] >= listColumn.get(i).size()) {
                return false;
            }
        }
        return true;
    }

    public boolean next(List result) {
        if (!hasNext()) {
            return false;
        }
        result.clear();
        for (int i = 0; i < counter.length; ++i) {
            result.add(listColumn.get(i).get(counter[i]));
        }
        increment();
        return true;
    }

    public Object next() {
        List result = new ArrayList(counter.length);
        if (next(result)) {
            return result;
        }
        return null;
    }

    public boolean increment() {
        int x = 0;
        counter[x]++;
        while (counter[x] >= listColumn.get(x).size()) {
            if (x + 1 >= counter.length) {
                return false;
            }
            counter[x] = 0;
            x++;
            counter[x]++;
        }
        return true;
    }

    public void remove() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}
