package jp.bne.deno.ordermaid.view.admin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import jp.bne.deno.ordermaid.dao.SystemTable;
import jp.bne.deno.ordermaid.report.SalesReportBuilder;
import jp.bne.deno.ordermaid.report.TotalReportBuilder;
import jp.bne.deno.ordermaid.view.BasePage;

import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.model.CompoundPropertyModel;

import com.google.inject.Inject;

/**
 * @author hasegawt
 */
public class SalesReportPage extends BasePage {

	@Inject
	SalesReportBuilder salesReportBuilder;

	@Inject
	TotalReportBuilder totalReportBuilder;

	@Inject
	SystemTable systemTable;

	String year;

	String month;

	public SalesReportPage() {

		Form<SalesReportPage> form = new Form<SalesReportPage>("form",
				new CompoundPropertyModel<SalesReportPage>(this));
		form.add(new FeedbackPanel("feedback"));
		final Calendar current = Calendar.getInstance();
		current.setTime(new Date());
		List<String> years = new ArrayList<String>();
		List<String> months = new ArrayList<String>();

		int baseYear = current.get(Calendar.YEAR);
		for (int i = baseYear - 2; i < baseYear + 2; i++) {
			years.add(Integer.toString(i));
		}
		year = Integer.toString(baseYear);
		for (int i = 1; i < 13; i++) {
			months.add(Integer.toString(i));
		}
		month = Integer.toString(current.get(Calendar.MONTH) + 1);

		DropDownChoice<String> yearChoice = new DropDownChoice<String>("year",
				years);
		DropDownChoice<String> monthChoice = new DropDownChoice<String>(
				"month", months);
		form.add(yearChoice);
		form.add(monthChoice);

		form.add(new Button("monthlyReport") {
			public void onSubmit() {
				try {
					// 当月の売上ファイル名作成.

					File file = new File(systemTable.getSystemItem("reportDir",
							"/tmp").getValue()
							+ "/売上集計_" + year + "年" + month + "月分.xls");

					InputStream stream = Thread.currentThread()
							.getContextClassLoader().getResourceAsStream(
									"template.xls");
					salesReportBuilder.initialize(file, stream);
					Calendar target = Calendar.getInstance();
					target.set(Integer.parseInt(year),
							Integer.parseInt(month) - 1, 1);
					salesReportBuilder.run(target);
					info(file.getAbsolutePath() + "を生成しました");
				} catch (IOException e) {
					error(e.getMessage());
				}
			}
		});

		form.add(new Button("totalReport") {
			public void onSubmit() {
				try {
					// 集計ファイル名作成.
					File file = new File(systemTable.getSystemItem("reportDir",
							"/tmp").getValue()
							+ "/通年集計.xls");

					InputStream stream = Thread.currentThread()
							.getContextClassLoader().getResourceAsStream(
									"template2.xls");
					totalReportBuilder.initialize(file, stream);
					totalReportBuilder.run();
					info(file.getAbsolutePath() + "を生成しました");
				} catch (IOException e) {
					error(e.getMessage());
				}
			}
		});

		add(form);
	}

}
