package jp.bne.deno.ordermaid.view.admin;

import java.util.ArrayList;
import java.util.List;

import jp.bne.deno.ordermaid.dao.MenuSetTable;
import jp.bne.deno.ordermaid.dao.MenuTypeTable;
import jp.bne.deno.ordermaid.model.MenuSet;
import jp.bne.deno.ordermaid.model.MenuType;
import jp.bne.deno.ordermaid.view.BasePage;

import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.CompoundPropertyModel;

import com.google.inject.Inject;

/**
 * @author hasegawt
 */
public class MenuTypePage extends BasePage {

	@Inject
	MenuTypeTable typeTable;

	@Inject
	MenuSetTable menuSetTable;

	List<MenuType> types = new ArrayList<MenuType>();

	private String newMenuType;

	private String newSort;

	private MenuSet newMenuSet = new MenuSet();

	private boolean newRequired = false;

	List<MenuSet> menuSetList = new ArrayList<MenuSet>();

	public MenuTypePage() {

		Form<MenuTypePage> form = new Form<MenuTypePage>("form",
				new CompoundPropertyModel<MenuTypePage>(this));

		types = typeTable.findAll();
		menuSetList = menuSetTable.findAll();

		form.add(new TextField<String>("newMenuType"));
		form.add(new TextField<String>("newSort"));
		form.add(new CheckBox("newRequired"));

		form.add(new DropDownChoice<MenuSet>("newMenuSet", menuSetList,
				menuSetRenderer));

		form.add(new Button("add") {
			public void onSubmit() {
				MenuType type = new MenuType();
				type.setMenuType(newMenuType);
				type.setSort(Integer.parseInt(newSort));
				type.setMenuSet(newMenuSet);
				type.setRequired(newRequired);
				typeTable.save(type);
				newMenuType = "";
				newSort = "";
				newMenuSet = new MenuSet();
				newRequired = false;
				types = typeTable.findAll();
			}
		});
		form.add(new ListView<MenuType>("types") {
			protected void populateItem(ListItem<MenuType> item) {
				final MenuType type = (MenuType) item.getModelObject();
				item.setModel(new CompoundPropertyModel<MenuType>(type));
				item.add(new TextField<String>("menuType"));
				item.add(new TextField<String>("sort"));
				item.add(new CheckBox("isRequired"));
				item.add(new DropDownChoice<MenuSet>("menuSet", menuSetList,
						menuSetRenderer));
				item.add(new Button("edit") {
					public void onSubmit() {
						setResponsePage(new MenuItemPage(type));
					}
				});

				item.add(new Button("save") {
					public void onSubmit() {
						typeTable.save(type);
						newMenuType = "";
						newSort = "";
						newMenuSet = new MenuSet();
						types = typeTable.findAll();
					}
				});
				item.add(new Button("remove") {
					public void onSubmit() {
						typeTable.remove(type.getMenuTypeId());
						newMenuType = "";
						newSort = "";
						newMenuSet = new MenuSet();
						types = typeTable.findAll();
					}
				});
			}
		});
		add(form);
	}

	private IChoiceRenderer<MenuSet> menuSetRenderer = new IChoiceRenderer<MenuSet>() {

		// @Override
		public Object getDisplayValue(MenuSet arg0) {
			return arg0.getMenuSetName();
		}

		// @Override
		public String getIdValue(MenuSet arg0, int arg1) {
			return Integer.toString(arg0.getMenuSetId());
		}

	};
}
