package jp.bne.deno.ordermaid.view.admin;

import java.util.ArrayList;
import java.util.List;

import jp.bne.deno.ordermaid.dao.MenuItemTable;
import jp.bne.deno.ordermaid.model.MenuItem;
import jp.bne.deno.ordermaid.model.MenuType;
import jp.bne.deno.ordermaid.view.BasePage;

import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.CompoundPropertyModel;

import com.google.inject.Inject;

/**
 * @author hasegawt
 */
public class MenuItemPage extends BasePage {

	@Inject
	MenuItemTable table;

	MenuType menuType;

	public MenuType getMenuType() {
		return menuType;
	}

	public void setMenuType(MenuType menuType) {
		this.menuType = menuType;
	}

	List<MenuItem> menus = new ArrayList<MenuItem>();

	private String newMenuName;
	private String newPrice;
	private String newShortName;
	private String newTypeAmount;
	private String newSort;

	public MenuItemPage(MenuType menuType) {
		this.menuType = menuType;
		Form<MenuItemPage> form = new Form<MenuItemPage>("form",
				new CompoundPropertyModel<MenuItemPage>(this));

		form.add(new TextField<String>("newMenuName"));
		form.add(new TextField<String>("newShortName"));
		form.add(new TextField<String>("newPrice"));
		form.add(new TextField<String>("newTypeAmount"));
		form.add(new TextField<String>("newSort"));

		menus = table.findByTypeId(getMenuType().getMenuTypeId());

		form.add(new Button("add") {
			public void onSubmit() {
				MenuItem menu = new MenuItem();
				menu.setMenuName(newMenuName);
				menu.setMenuType(getMenuType());
				menu.setPrice(Integer.parseInt(newPrice));
				menu.setShortName(newShortName);
				menu.setTypeAmount(Double.parseDouble(newTypeAmount));
				menu.setSort(Integer.parseInt(newSort));
				table.save(menu);
				menus = table.findByTypeId(getMenuType().getMenuTypeId());
				newMenuName = "";
				newPrice = "";
				newShortName = "";
				newTypeAmount = "";
				newSort = "";
			}
		});
		form.add(new ListView<MenuItem>("menus") {
			protected void populateItem(ListItem<MenuItem> item) {
				final MenuItem menu = item.getModelObject();
				item.setModel(new CompoundPropertyModel<MenuItem>(menu));
				item.add(new TextField<String>("menuName"));
				item.add(new TextField<String>("shortName"));
				item.add(new TextField<String>("price"));
				item.add(new TextField<String>("typeAmount"));
				item.add(new TextField<String>("sort"));
				item.add(new Button("save") {
					public void onSubmit() {
						menu.setMenuType(getMenuType());
						table.save(menu);
						menus = table.findByTypeId(getMenuType()
								.getMenuTypeId());

					}
				});
				item.add(new Button("remove") {
					public void onSubmit() {
						table.remove(menu.getMenuId());
						menus = table.findByTypeId(getMenuType()
								.getMenuTypeId());
					}
				});
			}
		});
		add(form);
	}

}
