package jp.bne.deno.ordermaid.view;

import java.util.ArrayList;
import java.util.List;

import jp.bne.deno.ordermaid.dao.OrderTable;
import jp.bne.deno.ordermaid.dao.SystemTable;
import jp.bne.deno.ordermaid.model.OrderData;
import jp.bne.deno.ordermaid.model.OrderDetail;

import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.model.CompoundPropertyModel;
import com.google.inject.Inject;

/**
 * @author hasegawt. テーブル状況照会.
 */
public class OrderListPage extends BasePage {

	@Inject
	OrderTable orderTable;
	@Inject
	SystemTable systemTable;

	private List<OrderDetail> list = new ArrayList<OrderDetail>();

	public OrderListPage() {
		Form<OrderListPage> form = new Form<OrderListPage>("form",
				new CompoundPropertyModel<OrderListPage>(this));
		form.add(new FeedbackPanel("feedback"));
		add(form);
		int sheetNum = Integer.parseInt(systemTable.getSystemItem("sheetNum",
				"10").getValue());

		for (int i = 1; i <= sheetNum; i++) {
			OrderDetail detail = orderTable.findBySheetId(i);
			detail.setSheetId(i);
			list.add(detail);
		}

		form.add(new ListView<OrderDetail>("list") {
			@Override
			protected void populateItem(ListItem<OrderDetail> item) {
				final OrderDetail data = (OrderDetail) item.getModelObject();
				item.setModel(new CompoundPropertyModel<OrderDetail>(data));
				Button edit = new Button("edit") {
					public void onSubmit() {
						OrderPage page = new OrderPage();
						OrderData order = orderTable.find(data.getOrder()
								.getOrderId());
						page.setOrderData(order);
						setResponsePage(page);
					}
				};
				item.add(edit);
				if (data.getOrder().getOrderId() == -1) {
					edit.setEnabled(false);
				} else {
					edit.setEnabled(true);
				}

				if (data.getOrder().getOrderId() == -1) {
					item.add(new Label("version", " "));
					item.add(new Label("orderId", " "));
				} else {
					item
							.add(new Label("version", data.getOrder()
									.getVersion()));
					item.add(new Label("orderId", Integer.toString(data
							.getOrder().getOrderId())));
				}
				item.add(new Label("orderDate"));
				item.add(new Label("sheetId"));
				item.add(new Label("menus"));
				item.add(new Label("sumPrice"));
			}
		});
	}
}
