package jp.bne.deno.ordermaid.view;

import jp.bne.deno.ordermaid.common.CommonModule;
import jp.bne.deno.ordermaid.common.SampleDataGenerator;
import jp.bne.deno.ordermaid.dao.SystemTable;
import jp.bne.deno.ordermaid.view.admin.SystemItemPage;

import com.google.inject.Guice;
import com.google.inject.Inject;

/**
 * @author hasegawt. メニュー画面
 */
public class IndexPage extends BasePage {

	private static final long serialVersionUID = 2697965769745018738L;

	@Inject
	SystemTable systemTable;

	public IndexPage() {
		// システム管理テーブルが未登録の場合、初期設定ページに飛ぶ。
		if (systemTable.findAll().size() == 0) {
			Guice.createInjector(new CommonModule()).getInstance(
					SampleDataGenerator.class).systemSettings();
			setResponsePage(SystemItemPage.class);
		}
	}
}
