package jp.bne.deno.ordermaid.service;

import java.io.File;
import java.io.IOException;

import jp.bne.deno.ordermaid.dao.SystemTable;
import jp.bne.deno.ordermaid.model.OrderData;
import jp.bne.deno.ordermaid.model.SystemItem;
import jp.bne.deno.ordermaid.print.OrderSheetBuilder;

import com.google.inject.Inject;
import com.lowagie.tools.Executable;

/**
 * 帳票印刷サービス
 * 
 * @author hasegawt
 * 
 */
public class PrinterServiceImpl implements PrinterService {

	@Inject
	private OrderSheetBuilder builder;

	@Inject
	private SystemTable table;

	/**
	 * 注文票を印刷する。
	 */
	public void printOrder(OrderData data) throws IOException {
		SystemItem printDir = table.getSystemItem("printDir", "/tmp");
		SystemItem printSheet = table.getSystemItem("printSheet", "false");
		SystemItem showSheet = table.getSystemItem("showSheet", "true");
		SystemItem acroread = table.getSystemItem("acroread", "");

		String filePath = printDir.getValue() + "/order.pdf";
		File file = new File(filePath);
		file = builder.build(data, file);

		if (acroread == null || acroread.getValue().equals("")) {
			Executable.acroread = null;
		} else {
			Executable.acroread = acroread.getValue();
		}

		if (Boolean.parseBoolean(printSheet.getValue())) {
			// 印刷する場合
			Executable.printDocumentSilent(file.getAbsolutePath(), false);
		}
		if (Boolean.parseBoolean(showSheet.getValue())) {
			// 画面表示する場合
			Executable.openDocument(file.getAbsolutePath(), false);
		}
	}
}
