package jp.bne.deno.ordermaid.model;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;

@Entity
public class MenuType implements Serializable {

	private static final long serialVersionUID = 2135958950978679426L;

	public MenuType() {

	}

	public MenuType(int sort, MenuSet menuSet, String menuType, boolean required) {
		this.sort = sort;
		this.menuSet = menuSet;
		this.menuType = menuType;
		this.required = required;
	}

	public boolean equals(MenuType o) {
		return (this.menuTypeId == o.getMenuTypeId());
	}

	@OneToMany(mappedBy = "menuType")
	@JoinColumn(name = "menutypeid")
	private Set<MenuItem> menuItems = new HashSet<MenuItem>();

	@ManyToOne
	@JoinColumn(name = "menusetid")
	private MenuSet menuSet = new MenuSet();

	private String menuType;

	@Id
	@GeneratedValue
	private int menuTypeId;

	@Column(nullable = false)
	private Integer sort = 0;

	@Column(nullable = false)
	private boolean required = false;

	public boolean isRequired() {
		return required;
	}

	public void setRequired(boolean isRequired) {
		this.required = isRequired;
	}

	public Set<MenuItem> getMenuItems() {
		return menuItems;
	}

	public MenuSet getMenuSet() {
		return menuSet;
	}

	public String getMenuType() {
		return menuType;
	}

	public int getMenuTypeId() {
		return menuTypeId;
	}

	public Integer getSort() {
		return sort;
	}

	public void setMenuItems(Set<MenuItem> menuItems) {
		this.menuItems = menuItems;
	}

	public void setMenuSet(MenuSet menuSet) {
		this.menuSet = menuSet;
	}

	public void setMenuType(String menuType) {
		this.menuType = menuType;
	}

	public void setMenuTypeId(int menuTypeId) {
		this.menuTypeId = menuTypeId;
	}

	public void setSort(Integer sort) {
		this.sort = sort;
	}

}
