package jp.bne.deno.ordermaid.model;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;

@Entity
public class MenuItem implements Serializable, Comparable<MenuItem>, Cloneable {

	private static final long serialVersionUID = -2294572981882403004L;

	@Id
	@GeneratedValue
	private int menuId;

	@Column(length = 255, nullable = false)
	private String menuName = "";

	@ManyToOne
	@JoinColumn(name = "menutypeid")
	private MenuType menuType;

	@Column(length = 7, scale = 0, nullable = false)
	private Integer price = 0;

	@Column(length = 20, nullable = false)
	private String shortName = "";

	@Column(length = 2, scale = 0, nullable = false)
	private Integer sort = 0;

	@Column(length = 3, scale = 2, nullable = false)
	private Double typeAmount;

	public MenuItem() {

	}

	public MenuItem(int sort, MenuType menuType, String menuName,
			String shortName, int price, double typeAmount) {
		this.sort = sort;
		this.menuType = menuType;
		this.menuName = menuName;
		this.shortName = shortName;
		this.price = price;
		this.typeAmount = typeAmount;
	}

	public MenuItem(int menuId) {
		this.menuId = menuId;
	}

	public int getMenuId() {
		return menuId;
	}

	public String getMenuName() {
		if (menuName != null) {
			return menuName;
		} else {
			return "";
		}
	}

	public MenuType getMenuType() {
		return menuType;
	}

	public Integer getPrice() {
		return price;
	}

	public String getShortName() {
		if (shortName != null) {
			return shortName;
		} else {
			return "";
		}
	}

	public Integer getSort() {
		return sort;
	}

	public Double getTypeAmount() {
		return typeAmount;
	}

	public void setMenuId(int menuId) {
		this.menuId = menuId;
	}

	public void setMenuName(String menuName) {
		this.menuName = menuName;
	}

	public void setMenuType(MenuType menuType) {
		this.menuType = menuType;
	}

	public void setPrice(Integer price) {
		this.price = price;
	}

	public void setShortName(String shortName) {
		this.shortName = shortName;
	}

	public void setSort(Integer sort) {
		this.sort = sort;
	}

	public void setTypeAmount(Double typeAmount) {
		this.typeAmount = typeAmount;
	}

	@Override
	public String toString() {
		return shortName;
	}

	/**
	 * 大小を比較する.
	 */
	// @Override
	public int compareTo(MenuItem o) {
		if (o != null && o.menuType != null && o.menuType.getSort() != null
				&& this.menuType != null
				&& o.menuType.getSort().equals(this.menuType.getSort())) {
			return getSort() - o.getSort();
		} else {
			return menuType.getSort() - o.menuType.getSort();
		}
	}
}
