package jp.bne.deno.ordermaid.common;

import jp.bne.deno.ordermaid.dao.MenuItemTable;
import jp.bne.deno.ordermaid.dao.MenuSetTable;
import jp.bne.deno.ordermaid.dao.MenuTypeTable;
import jp.bne.deno.ordermaid.dao.OrderTable;
import jp.bne.deno.ordermaid.dao.SystemTable;
import jp.bne.deno.ordermaid.model.MenuItem;
import jp.bne.deno.ordermaid.model.MenuSet;
import jp.bne.deno.ordermaid.model.MenuType;
import jp.bne.deno.ordermaid.model.SystemItem;

import com.google.inject.Inject;

public class SampleDataGenerator {
	@Inject
	MenuSetTable menuSetTable;

	@Inject
	MenuTypeTable menuTypeTable;

	@Inject
	MenuItemTable menuItemTable;

	@Inject
	OrderTable orderTable;

	@Inject
	SystemTable systemTable;

	/**
	 * 初期システム設定
	 */
	public void systemSettings() {
		if (systemTable.findAll().size() == 0) {
			// システム管理テーブルデフォルト設定
			systemTable.save(new SystemItem("reportDir", "/tmp",
					"レポート出力ディレクトリパス"));
			systemTable.save(new SystemItem("pageSize", "A6",
					"注文伝票を印刷する際の用紙サイズ"));
			systemTable.save(new SystemItem("printHeader", "", "注文伝票見出し部分文言"));
			systemTable.save(new SystemItem("printFooter", "", "注文伝票末尾部分文言"));
			systemTable.save(new SystemItem("printSheet", "false",
					"注文伝票をプリンタに出力する場合、true。それ以外はfalse。"));
			systemTable.save(new SystemItem("showSheet", "true",
					"注文伝票を印刷プレビューする場合、true。そうでない場合はfalse。"));
			systemTable.save(new SystemItem("sheetNum", "12", "店舗の座席数を設定。"));
			systemTable.save(new SystemItem("printDir", "/tmp",
					"印刷用PDFファイルを出力する一時ディレクトリパス"));
			systemTable.save(new SystemItem("acroread", "",
					"AdobeAcrobat Readerのパス"));
		}
		if (menuSetTable.findAll().size() == 0) {
			// メニュー管理
			menuSetTable.save(new MenuSet(1, "メイン"));
			menuSetTable.save(new MenuSet(2, "サイド"));
			menuSetTable.save(new MenuSet(3, "その他"));
		}
	}

	/**
	 * サンプルデータ生成.
	 */
	public void generate() {
		// システム管理テーブルデフォルト設定
		systemTable.save(new SystemItem("reportDir", "/tmp", "レポート出力ディレクトリパス"));
		systemTable.save(new SystemItem("pageSize", "A6", "注文伝票を印刷する際の用紙サイズ"));
		systemTable.save(new SystemItem("printHeader", "古野屋　徳鳥中央店",
				"注文伝票見出し部分文言"));
		systemTable.save(new SystemItem("printFooter",
				"※ここにはシステム毎に固有文言を入れられます。", "注文伝票フッター部分文言"));
		systemTable.save(new SystemItem("printSheet", "false",
				"注文伝票をプリンタに出力する場合、true。それ以外はfalse。"));
		systemTable.save(new SystemItem("showSheet", "true",
				"注文伝票を印刷プレビューする場合、true。そうでない場合はfalse。"));
		systemTable.save(new SystemItem("sheetNum", "12", "店舗の座席数を設定。"));
		systemTable.save(new SystemItem("printDir", "/tmp",
				"印刷用PDFファイルを出力する一時ディレクトリパス"));
		systemTable.save(new SystemItem("acroread", "",
				"AdobeAcrobat Readerのパス"));

		// メニュー管理
		menuSetTable.save(new MenuSet(1, "メイン"));
		menuSetTable.save(new MenuSet(2, "サイド"));
		menuSetTable.save(new MenuSet(3, "その他"));
		MenuSet menuSet1 = menuSetTable.find("メイン");
		MenuSet menuSet2 = menuSetTable.find("サイド");
		MenuSet menuSet3 = menuSetTable.find("その他");

		MenuType type1 = menuTypeTable.save(new MenuType(1, menuSet1, "丼もの",
				false));
		MenuType type2 = menuTypeTable.save(new MenuType(2, menuSet1, "ラーメン",
				false));
		MenuType type3 = menuTypeTable.save(new MenuType(3, menuSet2, "サイド",
				false));
		MenuType type4 = menuTypeTable.save(new MenuType(4, menuSet2, "トッピング",
				false));
		MenuType type5 = menuTypeTable.save(new MenuType(5, menuSet3, "飲み物",
				false));
		MenuType type6 = menuTypeTable.save(new MenuType(6, menuSet3, "デザート",
				false));

		menuItemTable.save(new MenuItem(1, type1, "牛丼", "牛", 500, 1));
		menuItemTable.save(new MenuItem(2, type1, "牛丼大盛", "牛大", 600, 1.5));
		menuItemTable.save(new MenuItem(3, type1, "ミニ牛丼", "ミニ牛", 400, 0.75));

		menuItemTable.save(new MenuItem(1, type2, "ラーメン", "ラ", 400, 1));
		menuItemTable.save(new MenuItem(2, type2, "ラーメン大盛", "ラ大", 500, 1.5));
		menuItemTable.save(new MenuItem(3, type2, "油そば", "油そば", 500, 1));
		menuItemTable.save(new MenuItem(4, type2, "油そば大盛", "油そば大", 650, 1.5));

		menuItemTable.save(new MenuItem(1, type3, "サラダ", "サラダ", 100, 1));
		menuItemTable.save(new MenuItem(2, type3, "味噌汁", "味噌汁", 50, 1));
		menuItemTable.save(new MenuItem(3, type3, "豚汁", "豚汁", 100, 1));

		menuItemTable.save(new MenuItem(1, type4, "生卵", "卵", 50, 1));
		menuItemTable.save(new MenuItem(2, type4, "納豆", "納豆", 50, 1));
		menuItemTable.save(new MenuItem(3, type4, "ネギ", "ネギ", 50, 1));
		menuItemTable.save(new MenuItem(4, type4, "チーズ", "チーズ", 50, 1));

		menuItemTable.save(new MenuItem(1, type5, "ビール", "麦酒", 400, 1));
		menuItemTable.save(new MenuItem(2, type5, "コーラ", "コーラ", 150, 1));
		menuItemTable.save(new MenuItem(3, type5, "烏龍茶", "烏龍茶", 150, 1));

		menuItemTable.save(new MenuItem(1, type6, "杏仁豆腐", "杏仁", 100, 1));
		menuItemTable.save(new MenuItem(2, type6, "アイス", "アイス", 100, 1));

	}
}
