package jp.bne.deno.ordermaid;

import jp.bne.deno.ordermaid.common.CommonModule;
import jp.bne.deno.ordermaid.common.SampleDataGenerator;
import jp.bne.deno.ordermaid.view.IndexPage;

import org.apache.wicket.Application;
import org.apache.wicket.Page;
import org.apache.wicket.guice.GuiceComponentInjector;
import org.apache.wicket.protocol.http.WebApplication;

import com.google.inject.Guice;

public class MyApplication extends WebApplication {

	/**
	 * 初期化処理
	 */
	@Override
	protected void init() {
		super.init();
		addComponentInstantiationListener(new GuiceComponentInjector(this,
				new CommonModule()));
		// リクエスト文字コード設定
		getRequestCycleSettings().setResponseRequestEncoding("UTF-8");
		// テンプレート文字コード設定
		getMarkupSettings().setDefaultMarkupEncoding("UTF-8");

		// Developmentモードの場合は、サンプルデータ作成
		if (getConfigurationType().equals(Application.DEVELOPMENT)) {
			Guice.createInjector(new CommonModule()).getInstance(
					SampleDataGenerator.class).generate();
		}

	}

	/**
	 * 初期ページ設定
	 */
	@Override
	public Class<? extends Page> getHomePage() {
		return IndexPage.class;
	}
}
