/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.injection;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.injection.IFieldValueFactory;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.panel.Panel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Injector {
    private static Injector instance = new Injector();
    private final Map<ClassLoader, ConcurrentHashMap<String, Field[]>> cache = Collections.synchronizedMap(new WeakHashMap());

    public static Injector getInstance() {
        return instance;
    }

    protected boolean isBoundaryClass(Class<?> clazz) {
        return clazz.equals(WebPage.class) || clazz.equals(Page.class) || clazz.equals(Panel.class) || clazz.equals(MarkupContainer.class) || clazz.equals(Component.class);
    }

    public Object inject(Object object, IFieldValueFactory factory) {
        Class<?> clazz = object.getClass();
        Field[] fields = null;
        ConcurrentHashMap<String, Object> container = this.cache.get(clazz.getClassLoader());
        if (container != null) {
            fields = container.get(clazz.getName());
        }
        if (fields == null) {
            fields = this.findFields(clazz, factory);
            container = new ConcurrentHashMap();
            container.put(clazz.getName(), fields);
            this.cache.put(clazz.getClassLoader(), container);
        }
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            try {
                Object value;
                if (field.get(object) != null || (value = factory.getFieldValue(field, object)) == null) continue;
                field.set(object, value);
                continue;
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("error while injecting object [" + object.toString() + "] of type [" + object.getClass().getName() + "]", e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("error while injecting object [" + object.toString() + "] of type [" + object.getClass().getName() + "]", e);
            }
        }
        return object;
    }

    private Field[] findFields(Class<?> clazz, IFieldValueFactory factory) {
        ArrayList<Field> matched = new ArrayList<Field>();
        while (clazz != null && !this.isBoundaryClass(clazz)) {
            Field[] fields = clazz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                if (!factory.supportsField(field)) continue;
                matched.add(field);
            }
            clazz = clazz.getSuperclass();
        }
        return matched.toArray(new Field[matched.size()]);
    }
}

