/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.validation.validator;

import java.util.Map;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.validator.AbstractValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StringValidator
extends AbstractValidator<String> {
    private static final long serialVersionUID = 1L;

    public static StringValidator exactLength(int length) {
        return new ExactLengthValidator(length);
    }

    public static StringValidator lengthBetween(int minimum, int maximum) {
        return new LengthBetweenValidator(minimum, maximum);
    }

    public static StringValidator maximumLength(int maximum) {
        return new MaximumLengthValidator(maximum);
    }

    public static StringValidator minimumLength(int minimum) {
        return new MinimumLengthValidator(minimum);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MinimumLengthValidator
    extends StringValidator {
        private static final long serialVersionUID = 1L;
        private final int minimum;

        public MinimumLengthValidator(int minimum) {
            this.minimum = minimum;
        }

        public final int getMinimum() {
            return this.minimum;
        }

        @Override
        protected void onValidate(IValidatable<String> validatable) {
            if (validatable.getValue().length() < this.minimum) {
                this.error(validatable);
            }
        }

        @Override
        protected String resourceKey() {
            return "StringValidator.minimum";
        }

        @Override
        protected Map<String, Object> variablesMap(IValidatable<String> validatable) {
            Map<String, Object> map = super.variablesMap(validatable);
            map.put("minimum", new Integer(this.minimum));
            map.put("length", new Integer(validatable.getValue().length()));
            return map;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MaximumLengthValidator
    extends StringValidator {
        private static final long serialVersionUID = 1L;
        private final int maximum;

        public MaximumLengthValidator(int maximum) {
            this.maximum = maximum;
        }

        public final int getMaximum() {
            return this.maximum;
        }

        @Override
        protected void onValidate(IValidatable<String> validatable) {
            if (validatable.getValue().length() > this.maximum) {
                this.error(validatable);
            }
        }

        @Override
        protected String resourceKey() {
            return "StringValidator.maximum";
        }

        @Override
        protected Map<String, Object> variablesMap(IValidatable<String> validatable) {
            Map<String, Object> map = super.variablesMap(validatable);
            map.put("maximum", new Integer(this.maximum));
            map.put("length", new Integer(validatable.getValue().length()));
            return map;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LengthBetweenValidator
    extends StringValidator {
        private static final long serialVersionUID = 1L;
        private final int maximum;
        private final int minimum;

        public LengthBetweenValidator(int minimum, int maximum) {
            this.minimum = minimum;
            this.maximum = maximum;
        }

        public final int getMaximum() {
            return this.maximum;
        }

        public final int getMinimum() {
            return this.minimum;
        }

        @Override
        protected void onValidate(IValidatable<String> validatable) {
            String value = validatable.getValue();
            if (value.length() < this.minimum || value.length() > this.maximum) {
                this.error(validatable);
            }
        }

        @Override
        protected String resourceKey() {
            return "StringValidator.range";
        }

        @Override
        protected Map<String, Object> variablesMap(IValidatable<String> validatable) {
            Map<String, Object> map = super.variablesMap(validatable);
            map.put("minimum", new Integer(this.minimum));
            map.put("maximum", new Integer(this.maximum));
            map.put("length", new Integer(validatable.getValue().length()));
            return map;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExactLengthValidator
    extends StringValidator {
        private static final long serialVersionUID = 1L;
        private final int length;

        public ExactLengthValidator(int length) {
            this.length = length;
        }

        public final int getLength() {
            return this.length;
        }

        @Override
        protected void onValidate(IValidatable<String> validatable) {
            if (validatable.getValue().length() != this.length) {
                this.error(validatable);
            }
        }

        @Override
        protected String resourceKey() {
            return "StringValidator.exact";
        }

        @Override
        protected Map<String, Object> variablesMap(IValidatable<String> validatable) {
            Map<String, Object> map = super.variablesMap(validatable);
            map.put("length", validatable.getValue() != null ? new Integer(validatable.getValue().length()) : 0);
            map.put("exact", new Integer(this.length));
            return map;
        }
    }
}

