/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.upload;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.wicket.util.upload.FileItem;
import org.apache.wicket.util.upload.FileItemFactory;
import org.apache.wicket.util.upload.FileUploadException;
import org.apache.wicket.util.upload.MultipartFormInputStream;
import org.apache.wicket.util.upload.ParameterParser;
import org.apache.wicket.util.upload.RequestContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FileUploadBase {
    public static final String CONTENT_TYPE = "Content-type";
    public static final String CONTENT_DISPOSITION = "Content-disposition";
    public static final String FORM_DATA = "form-data";
    public static final String ATTACHMENT = "attachment";
    public static final String MULTIPART = "multipart/";
    public static final String MULTIPART_FORM_DATA = "multipart/form-data";
    public static final String MULTIPART_MIXED = "multipart/mixed";
    public static final int MAX_HEADER_SIZE = 1024;
    private long sizeMax = -1L;
    private String headerEncoding;

    public static final boolean isMultipartContent(RequestContext ctx) {
        String contentType = ctx.getContentType();
        if (contentType == null) {
            return false;
        }
        return contentType.toLowerCase().startsWith(MULTIPART);
    }

    public abstract FileItemFactory getFileItemFactory();

    public abstract void setFileItemFactory(FileItemFactory var1);

    public long getSizeMax() {
        return this.sizeMax;
    }

    public void setSizeMax(long sizeMax) {
        this.sizeMax = sizeMax;
    }

    public String getHeaderEncoding() {
        return this.headerEncoding;
    }

    public void setHeaderEncoding(String encoding) {
        this.headerEncoding = encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FileItem> parseRequest(RequestContext ctx) throws FileUploadException {
        if (ctx == null) {
            throw new IllegalArgumentException("ctx parameter cannot be null");
        }
        ArrayList<FileItem> items = new ArrayList<FileItem>();
        String contentType = ctx.getContentType();
        if (null == contentType || !contentType.toLowerCase().startsWith(MULTIPART)) {
            throw new InvalidContentTypeException("the request doesn't contain a multipart/form-data or multipart/mixed stream, content type header is " + contentType);
        }
        int requestSize = ctx.getContentLength();
        if (requestSize == -1 && this.getSizeMax() != Long.MAX_VALUE) {
            throw new UnknownSizeException("the request was rejected because its size is unknown");
        }
        if (this.sizeMax >= 0L && (long)requestSize > this.sizeMax) {
            throw new SizeLimitExceededException("the request was rejected because its size exceeds allowed range");
        }
        try {
            byte[] boundary = this.getBoundary(contentType);
            if (boundary == null) {
                throw new FileUploadException("the request was rejected because no multipart boundary was found");
            }
            InputStream input = ctx.getInputStream();
            MultipartFormInputStream multi = new MultipartFormInputStream(input, boundary);
            multi.setHeaderEncoding(this.headerEncoding);
            boolean nextPart = multi.skipPreamble();
            int maxHeaderBytes = 65536;
            while (nextPart) {
                Map<String, String> headers = this.parseHeaders(multi.readHeaders(65536));
                String fieldName = this.getFieldName(headers);
                if (fieldName != null) {
                    String subContentType = this.getHeader(headers, CONTENT_TYPE);
                    if (subContentType != null && subContentType.toLowerCase().startsWith(MULTIPART_MIXED)) {
                        byte[] subBoundary = this.getBoundary(subContentType);
                        multi.setBoundary(subBoundary);
                        boolean nextSubPart = multi.skipPreamble();
                        while (nextSubPart) {
                            headers = this.parseHeaders(multi.readHeaders(65536));
                            if (this.getFileName(headers) != null) {
                                FileItem item = this.createItem(headers, false);
                                items.add(item);
                                OutputStream os = item.getOutputStream();
                                try {
                                    multi.readBodyData(os);
                                }
                                finally {
                                    os.close();
                                }
                            } else {
                                multi.discardBodyData();
                            }
                            nextSubPart = multi.readBoundary();
                        }
                        multi.setBoundary(boundary);
                    } else {
                        FileItem item = this.createItem(headers, this.getFileName(headers) == null);
                        items.add(item);
                        OutputStream os = item.getOutputStream();
                        try {
                            multi.readBodyData(os);
                        }
                        finally {
                            os.close();
                        }
                    }
                } else {
                    multi.discardBodyData();
                }
                nextPart = multi.readBoundary();
            }
        }
        catch (IOException e) {
            for (int i = 0; i < items.size(); ++i) {
                FileItem item = (FileItem)items.get(i);
                item.delete();
            }
            throw new FileUploadException("Processing of multipart/form-data request failed. " + e.getMessage(), e);
        }
        return items;
    }

    protected byte[] getBoundary(String contentType) {
        byte[] boundary;
        ParameterParser parser = new ParameterParser();
        parser.setLowerCaseNames(true);
        Map<String, String> params = parser.parse(contentType, ';');
        String boundaryStr = params.get("boundary");
        if (boundaryStr == null) {
            return null;
        }
        try {
            boundary = boundaryStr.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            boundary = boundaryStr.getBytes();
        }
        return boundary;
    }

    protected String getFileName(Map<String, String> headers) {
        String fileName = null;
        String cd = this.getHeader(headers, CONTENT_DISPOSITION);
        if (cd.startsWith(FORM_DATA) || cd.startsWith(ATTACHMENT)) {
            ParameterParser parser = new ParameterParser();
            parser.setLowerCaseNames(true);
            Map<String, String> params = parser.parse(cd, ';');
            if (params.containsKey("filename")) {
                fileName = params.get("filename");
                if (fileName != null) {
                    int index = (fileName = fileName.trim()).lastIndexOf(92);
                    if (index == -1) {
                        index = fileName.lastIndexOf(47);
                    }
                    if (index != -1) {
                        fileName = fileName.substring(index + 1);
                    }
                } else {
                    fileName = "";
                }
            }
        }
        return fileName;
    }

    protected String getFieldName(Map<String, String> headers) {
        String fieldName = null;
        String cd = this.getHeader(headers, CONTENT_DISPOSITION);
        if (cd != null && cd.startsWith(FORM_DATA)) {
            ParameterParser parser = new ParameterParser();
            parser.setLowerCaseNames(true);
            Map<String, String> params = parser.parse(cd, ';');
            fieldName = params.get("name");
            if (fieldName != null) {
                fieldName = fieldName.trim();
            }
        }
        return fieldName;
    }

    protected FileItem createItem(Map<String, String> headers, boolean isFormField) {
        return this.getFileItemFactory().createItem(this.getFieldName(headers), this.getHeader(headers, CONTENT_TYPE), isFormField, this.getFileName(headers));
    }

    protected Map<String, String> parseHeaders(String headerPart) {
        HashMap<String, String> headers = new HashMap<String, String>();
        char[] buffer = new char[1024];
        boolean done = false;
        int j = 0;
        try {
            while (!done) {
                int i = 0;
                while (i < 2 || buffer[i - 2] != '\r' || buffer[i - 1] != '\n') {
                    buffer[i++] = headerPart.charAt(j++);
                }
                String header = new String(buffer, 0, i - 2);
                if (header.equals("")) {
                    done = true;
                    continue;
                }
                if (header.indexOf(58) == -1) continue;
                String headerName = header.substring(0, header.indexOf(58)).trim().toLowerCase();
                String headerValue = header.substring(header.indexOf(58) + 1).trim();
                if (this.getHeader(headers, headerName) != null) {
                    headers.put(headerName, this.getHeader(headers, headerName) + ',' + headerValue);
                    continue;
                }
                headers.put(headerName, headerValue);
            }
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        return headers;
    }

    protected final String getHeader(Map<String, String> headers, String name) {
        return headers.get(name.toLowerCase());
    }

    public static class SizeLimitExceededException
    extends FileUploadException {
        private static final long serialVersionUID = 1L;

        public SizeLimitExceededException() {
        }

        public SizeLimitExceededException(String message) {
            super(message);
        }
    }

    public static class UnknownSizeException
    extends FileUploadException {
        private static final long serialVersionUID = 1L;

        public UnknownSizeException() {
        }

        public UnknownSizeException(String message) {
            super(message);
        }
    }

    public static class InvalidContentTypeException
    extends FileUploadException {
        private static final long serialVersionUID = 1L;

        public InvalidContentTypeException() {
        }

        public InvalidContentTypeException(String message) {
            super(message);
        }
    }
}

