/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.resource.locator;

import java.util.Iterator;
import java.util.Locale;
import org.apache.wicket.util.string.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocaleResourceNameIterator
implements Iterator<String> {
    private final String path;
    private final Locale locale;
    private int state = 0;
    private Locale currentLocale;
    private String currentPath;

    public LocaleResourceNameIterator(String path, Locale locale) {
        this.path = path;
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.currentLocale;
    }

    @Override
    public boolean hasNext() {
        return this.state < 4;
    }

    @Override
    public String next() {
        if (this.locale == null) {
            this.state = 999;
            return this.path;
        }
        if (this.state == 0) {
            ++this.state;
            this.currentLocale = this.locale;
            this.currentPath = this.path + '_' + this.locale.toString();
            return this.currentPath;
        }
        String language = this.locale.getLanguage();
        String country = this.locale.getCountry();
        if (this.state == 1) {
            ++this.state;
            if (!Strings.isEmpty(language) && !Strings.isEmpty(country)) {
                this.currentLocale = new Locale(language, country);
                String newPath = this.path + '_' + language + '_' + country;
                if (!this.currentPath.equals(newPath)) {
                    return newPath;
                }
            }
        }
        if (this.state == 2) {
            ++this.state;
            if (!Strings.isEmpty(language)) {
                this.currentLocale = new Locale(language);
                return this.path + '_' + language;
            }
        }
        ++this.state;
        this.currentLocale = null;
        return this.path;
    }

    @Override
    public void remove() {
    }
}

