/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.io;

import java.io.NotSerializableException;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.util.string.AppendingStringBuffer;

public class WicketSerializeableException
extends NotSerializableException {
    private static final long serialVersionUID = 1L;
    private final List<String> list = new ArrayList<String>();

    public WicketSerializeableException(String message) {
        super(message);
    }

    public WicketSerializeableException(String message, Throwable cause) {
        this(message);
        this.initCause(cause);
    }

    public String getMessage() {
        AppendingStringBuffer asb = new AppendingStringBuffer(super.getMessage());
        if (this.list.size() > 0) {
            asb.append("\n");
            int i = this.list.size();
            while (--i >= 0) {
                String element = this.list.get(i);
                asb.append(element);
                asb.append("->");
            }
            asb.setLength(asb.length() - 2);
        }
        asb.append("\nNOTE: if you feel Wicket is at fault with this exception").append(", please report to the mailing list. You can switch to ").append("JDK based serialization by calling: ").append("org.apache.wicket.util.lang.Objects.setObjectStreamFactory(").append("new IObjectStreamFactory.DefaultObjectStreamFactory()) ").append("e.g. in the init method of your application");
        return asb.toString();
    }

    public void addTrace(String traceString) {
        this.list.add(traceString);
    }
}

