/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.target.coding;

import java.lang.ref.WeakReference;
import org.apache.wicket.Application;
import org.apache.wicket.IRedirectListener;
import org.apache.wicket.IRequestTarget;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.Page;
import org.apache.wicket.PageParameters;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.Session;
import org.apache.wicket.protocol.http.PageExpiredException;
import org.apache.wicket.protocol.http.WebRequest;
import org.apache.wicket.protocol.http.request.WebRequestCodingStrategy;
import org.apache.wicket.request.RequestParameters;
import org.apache.wicket.request.target.coding.AbstractRequestTargetUrlCodingStrategy;
import org.apache.wicket.request.target.component.BookmarkableListenerInterfaceRequestTarget;
import org.apache.wicket.request.target.component.BookmarkablePageRequestTarget;
import org.apache.wicket.request.target.component.PageRequestTarget;
import org.apache.wicket.request.target.component.listener.ListenerInterfaceRequestTarget;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.string.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HybridUrlCodingStrategy
extends AbstractRequestTargetUrlCodingStrategy {
    protected final WeakReference<Class<? extends Page>> pageClassRef;
    private final boolean redirectOnBookmarkableRequest;
    public static final PageParametersMetaDataKey PAGE_PARAMETERS_META_DATA_KEY = new PageParametersMetaDataKey();
    private static final OriginalUrlTrailingSlashesCountMetaDataKey ORIGINAL_TRAILING_SLASHES_COUNT_METADATA_KEY = new OriginalUrlTrailingSlashesCountMetaDataKey();

    public static void setInitialPageParameters(Page page, PageParameters pageParameters) {
        page.setMetaData(PAGE_PARAMETERS_META_DATA_KEY, pageParameters);
    }

    public static PageParameters getInitialPagePageParameters(Page page) {
        return page.getMetaData(PAGE_PARAMETERS_META_DATA_KEY);
    }

    public HybridUrlCodingStrategy(String mountPath, Class<? extends Page> pageClass, boolean redirectOnBookmarkableRequest) {
        super(mountPath);
        if (mountPath.endsWith("/")) {
            throw new IllegalArgumentException("mountPath can not end with a '/': " + mountPath);
        }
        this.pageClassRef = new WeakReference<Class<? extends Page>>(pageClass);
        this.redirectOnBookmarkableRequest = redirectOnBookmarkableRequest;
    }

    public HybridUrlCodingStrategy(String mountPath, Class<? extends Page> pageClass) {
        this(mountPath, pageClass, true);
    }

    private int getTrailingSlashesCount(CharSequence seq) {
        int count = 0;
        for (int i = seq.length() - 1; i >= 0 && seq.charAt(i) == '/'; --i) {
            ++count;
        }
        return count;
    }

    protected boolean isRedirectOnBookmarkableRequest() {
        return this.redirectOnBookmarkableRequest;
    }

    protected boolean alwaysRedirectWhenPageMapIsSpecified() {
        return Application.exists() && Application.get().getSessionSettings().isPageIdUniquePerSession();
    }

    @Override
    public IRequestTarget decode(RequestParameters requestParameters) {
        String parametersFragment = requestParameters.getPath().substring(this.getMountPath().length());
        PageInfoExtraction extraction = this.extractPageInfo(parametersFragment);
        PageInfo pageInfo = extraction.getPageInfo();
        String pageMapName = pageInfo != null ? pageInfo.getPageMapName() : null;
        Integer pageVersion = pageInfo != null ? pageInfo.getVersionNumber() : null;
        Integer pageId = pageInfo != null ? pageInfo.getPageId() : null;
        PageParameters parameters = new PageParameters(this.decodeParameters(extraction.getUrlAfterExtraction(), requestParameters.getParameters()));
        if (requestParameters.getPageMapName() == null) {
            requestParameters.setPageMapName(pageMapName);
        } else {
            pageMapName = requestParameters.getPageMapName();
        }
        String interfaceParameter = (String)parameters.remove("wicket:interface");
        int originalUrlTrailingSlashesCount = this.getTrailingSlashesCount(extraction.getUrlAfterExtraction());
        boolean redirect = this.isRedirectOnBookmarkableRequest();
        if (!Strings.isEmpty(pageMapName) && this.alwaysRedirectWhenPageMapIsSpecified()) {
            redirect = true;
        }
        if (interfaceParameter != null) {
            WebRequestCodingStrategy.addInterfaceParameters(interfaceParameter, requestParameters);
            return new BookmarkableListenerInterfaceRequestTarget(pageMapName, (Class)this.pageClassRef.get(), parameters, requestParameters.getComponentPath(), requestParameters.getInterfaceName(), requestParameters.getVersionNumber());
        }
        if (pageId == null) {
            return new HybridBookmarkablePageRequestTarget(pageMapName, (Class)this.pageClassRef.get(), parameters, originalUrlTrailingSlashesCount, redirect);
        }
        Page page = Strings.isEmpty(pageMapName) && Application.exists() && Application.get().getSessionSettings().isPageIdUniquePerSession() ? Session.get().getPage(pageId, pageVersion != null ? pageVersion : 0) : Session.get().getPage(pageMapName, "" + pageId, pageVersion != null ? pageVersion : 0);
        if (page != null && page.getClass().equals(this.pageClassRef.get())) {
            requestParameters.setInterfaceName(IRedirectListener.INTERFACE.getName());
            RequestCycle.get().getRequest().setPage(page);
            return new PageRequestTarget(page);
        }
        if (requestParameters.getInterface() != null) {
            this.handleExpiredPage(pageMapName, (Class)this.pageClassRef.get(), originalUrlTrailingSlashesCount, redirect);
        }
        return new HybridBookmarkablePageRequestTarget(pageMapName, (Class)this.pageClassRef.get(), parameters, originalUrlTrailingSlashesCount, redirect);
    }

    protected IRequestTarget handleExpiredPage(String pageMapName, Class<? extends Page> pageClass, int trailingSlashesCount, boolean redirect) {
        throw new PageExpiredException("Request cannot be processed. The target page does not exist anymore.");
    }

    private Integer getOriginalOriginalTrailingSlashesCount(IRequestTarget requestTarget) {
        if (requestTarget instanceof ListenerInterfaceRequestTarget) {
            ListenerInterfaceRequestTarget target = (ListenerInterfaceRequestTarget)requestTarget;
            Page page = target.getPage();
            return page.getMetaData(ORIGINAL_TRAILING_SLASHES_COUNT_METADATA_KEY);
        }
        return null;
    }

    private PageParameters getPageParameters(IRequestTarget requestTarget) {
        if (requestTarget instanceof BookmarkablePageRequestTarget) {
            BookmarkablePageRequestTarget target = (BookmarkablePageRequestTarget)requestTarget;
            return target.getPageParameters();
        }
        if (requestTarget instanceof ListenerInterfaceRequestTarget) {
            ListenerInterfaceRequestTarget target = (ListenerInterfaceRequestTarget)requestTarget;
            Page page = target.getPage();
            return HybridUrlCodingStrategy.getInitialPagePageParameters(page);
        }
        return null;
    }

    private PageInfo getPageInfo(IRequestTarget requestTarget) {
        if (requestTarget instanceof BookmarkablePageRequestTarget) {
            BookmarkablePageRequestTarget target = (BookmarkablePageRequestTarget)requestTarget;
            if (target.getPageMapName() != null) {
                return new PageInfo(null, null, target.getPageMapName());
            }
            return null;
        }
        if (requestTarget instanceof ListenerInterfaceRequestTarget) {
            ListenerInterfaceRequestTarget target = (ListenerInterfaceRequestTarget)requestTarget;
            Page page = target.getPage();
            return new PageInfo(new Integer(page.getNumericId()), new Integer(page.getCurrentVersionNumber()), page.getPageMapName());
        }
        return null;
    }

    private void fixTrailingSlashes(AppendingStringBuffer buffer, int desiredCount) {
        int current = this.getTrailingSlashesCount(buffer);
        if (current > desiredCount) {
            buffer.setLength(buffer.length() - (current - desiredCount));
        } else if (desiredCount > current) {
            for (int toAdd = desiredCount - current; toAdd > 0; --toAdd) {
                buffer.append("/");
            }
        }
    }

    @Override
    public CharSequence encode(IRequestTarget requestTarget) {
        Integer trailingSlashesCount;
        if (!this.matches(requestTarget)) {
            throw new IllegalArgumentException("Unsupported request target type.");
        }
        PageParameters parameters = this.getPageParameters(requestTarget);
        PageInfo pageInfo = this.getPageInfo(requestTarget);
        AppendingStringBuffer url = new AppendingStringBuffer(40);
        url.append(this.getMountPath());
        if (parameters != null) {
            this.appendParameters(url, parameters);
        }
        if ((trailingSlashesCount = this.getOriginalOriginalTrailingSlashesCount(requestTarget)) != null) {
            this.fixTrailingSlashes(url, trailingSlashesCount);
        }
        return this.addPageInfo(url.toString(), pageInfo);
    }

    @Override
    public boolean matches(IRequestTarget requestTarget) {
        if (requestTarget instanceof BookmarkablePageRequestTarget) {
            BookmarkablePageRequestTarget target = (BookmarkablePageRequestTarget)requestTarget;
            return target.getPageClass().equals(this.pageClassRef.get());
        }
        if (requestTarget instanceof ListenerInterfaceRequestTarget) {
            ListenerInterfaceRequestTarget target = (ListenerInterfaceRequestTarget)requestTarget;
            return target.getPage().getClass().equals(this.pageClassRef.get()) && target.getRequestListenerInterface().equals(IRedirectListener.INTERFACE);
        }
        return false;
    }

    protected PageInfoExtraction extractPageInfo(String url) {
        int begin = url.lastIndexOf(this.getBeginSeparator());
        PageInfo last = null;
        String lastSubstring = "";
        while (begin != -1) {
            String substring = url.substring(begin);
            if (substring.length() > this.getBeginSeparator().length() + this.getEndSeparator().length() && substring.startsWith(this.getBeginSeparator()) && substring.endsWith(this.getEndSeparator())) {
                String pageInfoString = substring.substring(this.getBeginSeparator().length(), substring.length() - this.getEndSeparator().length());
                PageInfo info = PageInfo.parsePageInfo(pageInfoString);
                if (info == null) break;
                last = info;
                lastSubstring = substring;
            }
            begin = url.lastIndexOf(this.getBeginSeparator(), begin - 1);
        }
        if (last != null) {
            return new PageInfoExtraction(url.substring(0, url.length() - lastSubstring.length()), last);
        }
        return new PageInfoExtraction(url, null);
    }

    protected String getBeginSeparator() {
        return ".";
    }

    protected String getEndSeparator() {
        return "";
    }

    protected String addPageInfo(String url, PageInfo pageInfo) {
        if (pageInfo != null) {
            return url + this.getBeginSeparator() + pageInfo.toString() + this.getEndSeparator();
        }
        return url;
    }

    @Override
    public boolean matches(String path, boolean caseSensitive) {
        RequestCycle rc = RequestCycle.get();
        if (rc != null && ((WebRequest)rc.getRequest()).isAjax()) {
            return false;
        }
        if (Strings.startsWith(path, this.getMountPath(), caseSensitive)) {
            String substring;
            PageInfo info;
            String remainder = path.substring(this.getMountPath().length());
            if (remainder.length() == 0 || remainder.startsWith("/")) {
                return true;
            }
            if (remainder.length() > this.getBeginSeparator().length() + this.getEndSeparator().length() && remainder.startsWith(this.getBeginSeparator()) && remainder.endsWith(this.getEndSeparator()) && (info = PageInfo.parsePageInfo(substring = remainder.substring(this.getBeginSeparator().length(), remainder.length() - this.getEndSeparator().length()))) != null) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "HybridUrlCodingStrategy[page=" + this.pageClassRef.get() + "]";
    }

    protected static class PageInfoExtraction {
        private final String urlAfterExtraction;
        private final PageInfo pageInfo;

        public PageInfoExtraction(String urlAfterExtraction, PageInfo pageInfo) {
            this.urlAfterExtraction = urlAfterExtraction;
            this.pageInfo = pageInfo;
        }

        public PageInfo getPageInfo() {
            return this.pageInfo;
        }

        public String getUrlAfterExtraction() {
            return this.urlAfterExtraction;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HybridBookmarkablePageRequestTarget
    extends BookmarkablePageRequestTarget {
        private final int originalUrlTrailingSlashesCount;
        private final boolean redirect;

        public HybridBookmarkablePageRequestTarget(String pageMapName, Class<? extends Page> pageClass, PageParameters pageParameters, int originalUrlTrailingSlashesCount, boolean redirect) {
            super(pageMapName, pageClass, pageParameters);
            this.originalUrlTrailingSlashesCount = originalUrlTrailingSlashesCount;
            this.redirect = redirect;
        }

        @Override
        protected <C extends Page> Page newPage(Class<C> pageClass, RequestCycle requestCycle) {
            Page page = super.newPage(pageClass, requestCycle);
            page.setMetaData(PAGE_PARAMETERS_META_DATA_KEY, new PageParameters(this.getPageParameters()));
            page.setMetaData(ORIGINAL_TRAILING_SLASHES_COUNT_METADATA_KEY, new Integer(this.originalUrlTrailingSlashesCount));
            return page;
        }

        @Override
        public void respond(RequestCycle requestCycle) {
            Page page = this.getPage(requestCycle);
            if (!page.isPageStateless() && this.redirect) {
                requestCycle.redirectTo(page);
            } else {
                super.respond(requestCycle);
            }
        }
    }

    protected static class PageInfo {
        private final Integer pageId;
        private final Integer versionNumber;
        private final String pageMapName;

        public PageInfo(Integer pageId, Integer versionNumber, String pageMapName) {
            if (pageId == null && (versionNumber != null || pageMapName == null) || versionNumber == null && (pageId != null || pageMapName == null)) {
                throw new IllegalArgumentException("Either both pageId and versionNumber must be null or none of them.");
            }
            this.pageId = pageId;
            this.versionNumber = versionNumber;
            this.pageMapName = pageMapName;
        }

        public Integer getPageId() {
            return this.pageId;
        }

        public Integer getVersionNumber() {
            return this.versionNumber;
        }

        public String getPageMapName() {
            return this.pageMapName;
        }

        private static char getPageInfoSeparator() {
            return '.';
        }

        public String toString() {
            boolean pmContainsLetter;
            String pageMapName = this.pageMapName;
            if (pageMapName != null && this.pageId != null && Application.exists() && Application.get().getSessionSettings().isPageIdUniquePerSession()) {
                pageMapName = null;
            }
            AppendingStringBuffer buffer = new AppendingStringBuffer(5);
            boolean pmEmpty = Strings.isEmpty(pageMapName);
            boolean bl = pmContainsLetter = !pmEmpty && !PageInfo.isNumber(pageMapName);
            if (this.pageId != null && pmEmpty && this.versionNumber == 0) {
                buffer.append(this.pageId);
            } else if (this.pageId != null && pmEmpty && this.versionNumber != 0) {
                buffer.append(this.pageId);
                buffer.append(PageInfo.getPageInfoSeparator());
                buffer.append(this.versionNumber);
            } else if (this.pageId == null && pmContainsLetter) {
                buffer.append(pageMapName);
            } else if (this.pageId == null && !pmEmpty && !pmContainsLetter) {
                buffer.append(PageInfo.getPageInfoSeparator());
                buffer.append(pageMapName);
            } else if (pmContainsLetter && this.pageId != null && this.versionNumber == 0) {
                buffer.append(pageMapName);
                buffer.append(PageInfo.getPageInfoSeparator());
                buffer.append(this.pageId);
            } else if (!pmEmpty && this.pageId != null) {
                buffer.append(pageMapName);
                buffer.append(PageInfo.getPageInfoSeparator());
                buffer.append(this.pageId);
                buffer.append(PageInfo.getPageInfoSeparator());
                buffer.append(this.versionNumber);
            }
            return buffer.toString();
        }

        private static boolean isNumber(String string) {
            if (string == null || string.length() == 0) {
                return false;
            }
            for (int i = 0; i < string.length(); ++i) {
                if (Character.isDigit(string.charAt(i))) continue;
                return false;
            }
            return true;
        }

        public static PageInfo parsePageInfo(String src) {
            if (src == null || src.length() == 0) {
                return null;
            }
            String[] segments = Strings.split(src, PageInfo.getPageInfoSeparator());
            if (segments.length > 3) {
                return null;
            }
            for (int i = 0; i < segments.length; ++i) {
                for (int j = 0; j < segments[i].length(); ++j) {
                    char c = segments[i].charAt(j);
                    if (Character.isLetterOrDigit(c) || c == '-' || c == '_') continue;
                    return null;
                }
            }
            if (segments.length == 1 && PageInfo.isNumber(segments[0])) {
                return new PageInfo(Integer.valueOf(segments[0]), new Integer(0), null);
            }
            if (segments.length == 2 && PageInfo.isNumber(segments[0]) && PageInfo.isNumber(segments[1])) {
                return new PageInfo(Integer.valueOf(segments[0]), Integer.valueOf(segments[1]), null);
            }
            if (segments.length == 1 && !PageInfo.isNumber(segments[0])) {
                return new PageInfo(null, null, segments[0]);
            }
            if (segments.length == 2 && segments[0].length() == 0) {
                return new PageInfo(null, null, segments[1]);
            }
            if (segments.length == 2 && !PageInfo.isNumber(segments[0]) && PageInfo.isNumber(segments[1])) {
                return new PageInfo(Integer.valueOf(segments[1]), new Integer(0), segments[0]);
            }
            if (segments.length == 3) {
                if (segments[2].length() == 0 && PageInfo.isNumber(segments[1])) {
                    return new PageInfo(Integer.valueOf(segments[1]), new Integer(0), segments[0]);
                }
                if (PageInfo.isNumber(segments[1]) && PageInfo.isNumber(segments[2])) {
                    return new PageInfo(Integer.valueOf(segments[1]), Integer.valueOf(segments[2]), segments[0]);
                }
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OriginalUrlTrailingSlashesCountMetaDataKey
    extends MetaDataKey<Integer> {
        private static final long serialVersionUID = 1L;

        private OriginalUrlTrailingSlashesCountMetaDataKey() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PageParametersMetaDataKey
    extends MetaDataKey<PageParameters> {
        private static final long serialVersionUID = 1L;

        private PageParametersMetaDataKey() {
        }
    }
}

