/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.https;

import org.apache.wicket.IRequestTarget;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.Session;
import org.apache.wicket.protocol.http.WebRequestCycleProcessor;
import org.apache.wicket.protocol.https.HttpsConfig;
import org.apache.wicket.protocol.https.RequireHttps;
import org.apache.wicket.protocol.https.SwitchProtocolRequestTarget;
import org.apache.wicket.request.RequestParameters;
import org.apache.wicket.request.target.component.IBookmarkablePageRequestTarget;
import org.apache.wicket.request.target.component.IPageRequestTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpsRequestCycleProcessor
extends WebRequestCycleProcessor {
    private final HttpsConfig portConfig;

    public HttpsRequestCycleProcessor(HttpsConfig httpsConfig) {
        this.portConfig = httpsConfig;
    }

    public HttpsConfig getConfig() {
        return this.portConfig;
    }

    private boolean hasSecureAnnotation(Class<?> klass) {
        for (Class<?> c : klass.getInterfaces()) {
            if (!this.hasSecureAnnotation(c)) continue;
            return true;
        }
        if (klass.getAnnotation(RequireHttps.class) != null) {
            return true;
        }
        if (klass.getSuperclass() != null) {
            return this.hasSecureAnnotation(klass.getSuperclass());
        }
        return false;
    }

    private Class<?> getPageClass(IRequestTarget target) {
        if (target instanceof IPageRequestTarget) {
            return ((IPageRequestTarget)target).getPage().getClass();
        }
        if (target instanceof IBookmarkablePageRequestTarget) {
            return ((IBookmarkablePageRequestTarget)target).getPageClass();
        }
        return null;
    }

    protected IRequestTarget checkSecure(IRequestTarget target) {
        if (this.portConfig == null) {
            return target;
        }
        Class<?> pageClass = this.getPageClass(target);
        if (pageClass != null) {
            IRequestTarget redirect = null;
            redirect = this.hasSecureAnnotation(pageClass) ? SwitchProtocolRequestTarget.requireProtocol(SwitchProtocolRequestTarget.Protocol.HTTPS) : SwitchProtocolRequestTarget.requireProtocol(SwitchProtocolRequestTarget.Protocol.HTTP);
            if (redirect != null) {
                return redirect;
            }
        }
        return target;
    }

    @Override
    public IRequestTarget resolve(RequestCycle rc, RequestParameters rp) {
        Session.get().bind();
        IRequestTarget target = super.resolve(rc, rp);
        return this.checkSecure(target);
    }
}

